<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2025 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

namespace JoomShaper\SPPageBuilder\DynamicContent\Constants;

defined('_JEXEC') or die;

/**
 * Collection ID constants for special system collections
 * 
 * @since 6.0.0
 */
class ArticleLayouts
{
    const DEFAULT_LAYOUT_ARTICLE_INDEX = '[{"id":"641783be-87ab-48bd-bf40-d84c73888d55","visibility":true,"collapse":false,"settings":{"admin_label":"","fit_columns":{"xl":true,"sm":false},"background_type":"none","background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"background_image":{"src":""},"background_parallax":"0","background_repeat":"no-repeat","background_size":"cover","background_size_custom":{"unit":"px"},"background_attachment":"fixed","background_position":"0 0","background_position_custom_x":{"unit":"px"},"background_position_custom_y":{"unit":"px"},"external_background_video":0,"background_video_ogv":{"src":""},"video_loop":1,"padding":{"xl":"75px 0px 75px 0px","lg":"","md":"","sm":"","xs":""},"margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"overlay_type":"overlay_none","gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"pattern_overlay":"","overlay_pattern_color":"","blend_mode":"normal","columns_align_center":0,"columns_content_alignment":"center","stretch_section":0,"fullscreen":0,"no_gutter":0,"row_width":{"unit":"px"},"row_max_width":{"unit":"px"},"row_min_width":{"unit":"px"},"row_border":0,"row_border_style":"solid","show_top_shape":"","shape_name":"clouds-flat","shape_color":"#e5e5e5","shape_width":{"md":100,"sm":100,"xs":100},"shape_height":"","shape_flip":false,"shape_invert":false,"shape_to_front":false,"show_bottom_shape":"","bottom_shape_name":"clouds-opacity","bottom_shape_color":"#e5e5e5","bottom_shape_width":{"xl":100},"bottom_shape_height":"","bottom_shape_flip":false,"bottom_shape_invert":false,"bottom_shape_to_front":false,"acl":"","row_boxshadow":"0 0 0 0 #FFFFFF","row_custom_css":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_position":"center","hidden_xl":"","hidden_lg":"","hidden_md":"","hidden_sm":"","hidden_xs":"","enable_animation":"1","animationduration":"300","animationdelay":"0"},"layout":"12","columns":[{"id":"2806f07e-cd59-474c-95eb-f38716e40fdd","class_name":"row-column","visibility":true,"settings":{"background_type":"none","background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"background_image":{"src":""},"background_repeat":"no-repeat","background_size":"cover","background_size_custom":{"unit":"px"},"background_attachment":"scroll","background_position":"0 0","background_position_custom_x":{"unit":"px"},"background_position_custom_y":{"unit":"px"},"overlay_type":"overlay_color","gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"pattern_overlay":{"src":""},"overlay_pattern_color":"","blend_mode":"normal","use_border":0,"border_width":"","boxshadow":"0 0 0 0 #FFFFFF","items_align_center":0,"items_content_alignment":"center","column_custom_css":"","tablet_order_landscape":"","tablet_order":"","mobile_order_landscape":"","mobile_order":"","hidden_xl":"","hidden_lg":"","hidden_md":"","hidden_sm":"","hidden_xs":"","enable_animation":"1","animationduration":"300","animationdelay":"0","width":{"xl":"100%","lg":"100%","md":"100%","sm":"100%","xs":"100%"}},"addons":[{"id":"a2ebb474-7a18-42e0-a659-798ea30f57aa","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["3448d774-0707-47a5-a64d-a84b2e21b89a"]},{"id":"3448d774-0707-47a5-a64d-a84b2e21b89a","type":"content","name":"heading","visibility":true,"title":"Heading","icon":"<svg viewBox=\"0 0 32 32\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path d=\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"title":"Blog Posts","heading_selector":"h1","title_text_shadow":"0 0 0 transparent","alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"title_icon_position":"before","title_margin":{"xl":"0px 0px 90px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":88},"heading_typography":{"font":"Arial","uppercase":true,"italic":false,"underline":false,"weight":"700","size":{"xl":{"value":"90","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"-4","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"title_color":{"type":"solid","color":"#474652","color2":"","pos":0,"pos2":100,"deg":0,"radialPos":"center center"}},"parent":"a2ebb474-7a18-42e0-a659-798ea30f57aa"},{"id":"127467ce-57ea-4b87-8c40-bb00568b6550","type":"dynamic-content","name":"dynamic_content_collection","visibility":true,"title":"Collection","icon":"<svg width=\"32\" height=\"32\" viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.467 6.91c0-.083.059-.309.523-.638.445-.315 1.136-.63 2.056-.906 1.831-.549 4.404-.9 7.278-.9 2.874 0 5.447.351 7.278.9.92.276 1.612.59 2.056.906.464.329.524.555.524.639 0 .083-.06.31-.524.638-.444.316-1.136.63-2.056.906-1.83.55-4.404.9-7.278.9-2.874 0-5.447-.35-7.278-.9-.92-.276-1.611-.59-2.056-.906-.464-.329-.523-.555-.523-.638ZM16.324 3c-2.975 0-5.697.36-7.7.962-.996.298-1.856.669-2.483 1.114C5.533 5.506 5 6.116 5 6.91c0 .033 0 .066.003.099A.74.74 0 0 0 5 7.074h.008H5v16.567c0 .816.477 1.488 1.1 2 .628.516 1.492.948 2.495 1.296 2.012.7 4.745 1.12 7.73 1.12 2.983 0 5.716-.42 7.729-1.12 1.003-.349 1.867-.78 2.494-1.296.623-.512 1.1-1.184 1.1-2V7.075h-.007v-.001h.007a.73.73 0 0 0-.003-.065c.002-.032.003-.065.003-.098 0-.795-.533-1.404-1.141-1.835-.627-.445-1.487-.816-2.483-1.114C22.022 3.36 19.299 3 16.324 3Zm9.858 5.957c-.586.352-1.324.653-2.158.903-2.002.6-4.725.961-7.7.961-2.975 0-5.697-.36-7.7-.961-.833-.25-1.571-.55-2.157-.903v6.771c0 .084.062.31.523.636.445.316 1.136.63 2.056.906 1.831.55 4.404.9 7.278.9 2.874 0 5.447-.35 7.278-.9.92-.276 1.612-.59 2.056-.906.464-.329.524-.555.524-.638V8.957ZM6.467 23.641v-5.868c.586.352 1.324.652 2.158.902 2.002.6 4.724.961 7.7.961 2.974 0 5.697-.36 7.699-.961.834-.25 1.572-.55 2.158-.902v5.868c0 .2-.116.497-.565.867-.444.365-1.131.726-2.045 1.044-1.82.633-4.383 1.037-7.248 1.037s-5.427-.404-7.248-1.037c-.914-.318-1.6-.68-2.045-1.044-.449-.37-.564-.666-.564-.867Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonId {\n  max-width: 1168px;\n  margin: 0 auto;\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"direction":"asc","filters":"","limit":"10","pagination":1,"pagination_type":"load-more","pagination_load_more_button_text":"Load More","pagination_buttons_position":"start","pagination_load_more_button_type":"primary","display":"grid","grid_columns":{"xl":"2","sm":"1"},"flex_direction":"column","flex_wrap":"wrap","vertical_alignment":"start","horizontal_alignment":"start","column_gap":{"xl":"24"},"row_gap":{"xl":"70"},"item_options":"normal","source":-2,"no_records_message":"","no_records_description":"","item_width":{"xl":""},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":13},"pagination_margin":{"xl":"35px 0px 0px 0px"}},"child_nodes":[{"id":"87f78113-a91d-4387-b82a-f26d4b8479d5","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"block","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"child_nodes":[{"id":"dbbc4788-adba-4db1-b1e6-3646820e429e","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":{"xl":"0px 0px 18px 0px"},"global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"8","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"sppb-readmore-wrapper","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"block","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible","global_background_color":""},"child_nodes":[{"id":"8f0be00f-5921-4ff3-a866-0df12748f6b8","type":"dynamic-content","name":"dynamic_content_image","visibility":true,"title":"Dynamic Media","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M3 8.792C3 6.698 4.712 5 6.824 5h15.295c2.112 0 3.824 1.698 3.824 3.792v6.066a.758.758 0 0 1-.472.7.77.77 0 0 1-.833-.163l-3.23-3.202a.769.769 0 0 0-1.189.134l-5.446 8.64c-.854 1.356-2.814 1.439-3.781.16l-1.885-2.492a.768.768 0 0 0-1.268.064l-3.301 5.455a2.287 2.287 0 0 0 2.286 2.08h7.648c.422 0 .764.339.764.758a.762.762 0 0 1-.764.758H6.824C4.712 27.75 3 26.052 3 23.958V8.792ZM4.53 21.22l1.997-3.302c.839-1.385 2.826-1.487 3.803-.195l1.886 2.493a.768.768 0 0 0 1.26-.053l5.446-8.64a2.306 2.306 0 0 1 3.568-.404l1.924 1.908V8.792a2.285 2.285 0 0 0-2.295-2.275H6.824A2.285 2.285 0 0 0 4.53 8.792V21.22ZM9.118 9.55c-.845 0-1.53.679-1.53 1.517 0 .837.686 1.516 1.53 1.516.845 0 1.53-.679 1.53-1.516 0-.838-.685-1.517-1.53-1.517ZM6.06 11.067c0-1.676 1.37-3.034 3.06-3.034 1.689 0 3.058 1.358 3.058 3.034 0 1.675-1.37 3.033-3.059 3.033-1.69 0-3.059-1.358-3.059-3.033Zm18.579 5.59a.77.77 0 0 1 1.081 0l2.715 2.692.001.002.018.017c.095.093.214.209.303.323.108.14.244.363.244.667 0 .304-.136.527-.244.667-.09.114-.208.23-.303.322l-.018.018-.001.002-2.715 2.69a.77.77 0 0 1-1.081 0 .754.754 0 0 1 0-1.072l1.885-1.869h-5.942c-1.197 0-2.285 1.078-2.285 2.559 0 1.48 1.088 2.558 2.285 2.558h3.05c.422 0 .765.34.765.759a.762.762 0 0 1-.765.758h-3.05c-2.172 0-3.815-1.892-3.815-4.075 0-2.184 1.643-4.076 3.815-4.076h5.942l-1.885-1.869a.754.754 0 0 1 0-1.072Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"sppb-readmore-img","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"xl":"","lg":"","md":"","sm":"","xs":"","unit":"px"},"global_addon_position_top":{"xl":"","lg":"","md":"","sm":"","xs":"","unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"item_alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"enable_slider":0,"enable_arrows":0,"slider_style":"thumb","image_per_slide":1,"gallery_width":{"xl":200},"gallery_height":{"xl":200},"gallery_item_gap":{"xl":0},"gallery_border_radius":0,"gallery_heading_selector":"h3","mp4_enable":0,"show_control":1,"video_loop":0,"video_mute":1,"autoplay_video":0,"download_video":1,"show_rel_video":0,"no_cookie":0,"youtube_shorts":0,"vimeo_show_author":0,"vimeo_mute_video":1,"vimeo_show_author_profile":0,"vimeo_show_video_title":0,"image_fit":"cover","is_effects_enabled":0,"attribute":{"id":-6,"name":"Featured Image","fullname":"Articles > Featured Image","type":"image","level":2,"path":"featured_image"},"height":{"xl":"462"},"margin":{"xl":"0px 0px 0px 0px"},"radius":{"xl":"8"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":148},"global_addon_z_index":""}}]}]},{"id":"48ff5f38-7246-4c38-b045-f6426d3fb1f5","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"flex-start","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"8px","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"child_nodes":[{"id":"6a3a4c70-6296-4a5c-8514-09018cfb50d6","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-18,"name":"Category","fullname":"Articles > Category","type":"text","level":2,"path":"category"},"color":"#868686","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":138}}},{"id":"53d27dc2-7827-48c2-9e7d-999dba356ed8","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"7px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-16,"name":"Created Date","fullname":"Articles > Created Date","type":"date-time","level":2,"path":"created","date_format":"d M, Y"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":298},"color":"#868686","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"icon":"fas fa-circle","icon_color":"#474652"}}]},{"id":"d9ed670f-ddd1-43be-bd5e-9072b37858b9","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"h5","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"15px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-3,"name":"Title","fullname":"Articles > Title","type":"text","level":2,"path":"title"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":138},"typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"700","size":{"xl":{"value":"24","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"color":"#474652"}},{"id":"65c0f743-fd83-4765-a093-f8f77721ab91","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"8px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-4,"name":"Intro Text","fullname":"Articles > Intro Text","type":"rich-text","level":2,"path":"introtext"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":298},"color":"#474652","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"","size":{"xl":{"value":"16","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""}}},{"id":"12bfb2d4-ef4a-4671-adf4-d3ad02de40c4","type":"general","name":"button","visibility":true,"title":"Button","icon":"<svg viewBox=\"0 0 32 32\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\" fill=\"currentColor\"\/><path opacity=\".5\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":{"xl":"   "},"global_margin":{"xl":"18px 0px 0px 0px"},"global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonId a {\n  padding-left: 0px;\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"text":"Read More","aria_label":"","type":"custom","appearance":"","shape":"rounded","button_padding":{"xl":"4px 12px 4px 12px"},"alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"icon_position":"right","icon_margin":{"xl":"1px 0px 1px 2px","lg":"","md":"","sm":"","xs":""},"button_style_state":"hover","color":"#656470","color_hover":"#FFFFFF","background_color":"#F5F5F5","background_color_hover":"#6C63FF","background_gradient":{"color":"#3366FF","color2":"#0037DD","deg":"45","type":"linear"},"background_gradient_hover":{"color":"#0037DD","color2":"#3366FF","deg":"45","type":"linear"},"button_link_style_state":"normal","link_button_color":"#3366FF","link_button_border_width":"1","link_border_color":"#3366FF","link_button_hover_color":"#0037DD","link_button_border_hover_color":"#0037DD","url":{"type":"page","url":"","menu":"","page":-2,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":140},"typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"700","size":{"xl":{"value":"16","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"22","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"size":"custom","icon":"fas fa-chevron-right"},"parent":false}],"parent":"a8b4c45b-0ca5-48a0-a08e-8c5f2cce77a5"},{"id":"a8b4c45b-0ca5-48a0-a08e-8c5f2cce77a5","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"block","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["127467ce-57ea-4b87-8c40-bb00568b6550"]}]}],"parent":false}]';

    const DEFAULT_LAYOUT_ARTICLE_DETAILS = '[{"id":"9041b86a-fd75-4b0a-8ac0-861a319e6655","visibility":true,"collapse":false,"settings":{"admin_label":"","fit_columns":{"xl":true,"sm":false},"background_type":"none","background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"background_image":{"src":""},"background_parallax":"0","background_repeat":"no-repeat","background_size":"cover","background_size_custom":{"unit":"px"},"background_attachment":"fixed","background_position":"0 0","background_position_custom_x":{"unit":"px"},"background_position_custom_y":{"unit":"px"},"external_background_video":0,"background_video_ogv":{"src":""},"video_loop":1,"padding":{"xl":"75px 0px 75px 0px","lg":"","md":"","sm":"","xs":""},"margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"overlay_type":"overlay_none","gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"pattern_overlay":"","overlay_pattern_color":"","blend_mode":"normal","columns_align_center":0,"columns_content_alignment":"center","stretch_section":0,"fullscreen":0,"no_gutter":0,"row_width":{"xl":"","lg":"","md":"","sm":"","xs":"","unit":"px"},"row_max_width":{"xl":"","lg":"","md":"","sm":"","xs":"","unit":"px"},"row_min_width":{"xl":"","lg":"","md":"","sm":"","xs":"","unit":"px"},"row_border":0,"row_border_style":"solid","show_top_shape":"","shape_name":"clouds-flat","shape_color":"#e5e5e5","shape_width":{"md":100,"sm":100,"xs":100},"shape_height":"","shape_flip":false,"shape_invert":false,"shape_to_front":false,"show_bottom_shape":"","bottom_shape_name":"clouds-opacity","bottom_shape_color":"#e5e5e5","bottom_shape_width":{"xl":100},"bottom_shape_height":"","bottom_shape_flip":false,"bottom_shape_invert":false,"bottom_shape_to_front":false,"acl":"","row_boxshadow":"0 0 0 0 #FFFFFF","row_custom_css":"","heading_selector":"h3","title_fontsize":"","title_fontweight":"","title_position":"center","hidden_xl":"","hidden_lg":"","hidden_md":"","hidden_sm":"","hidden_xs":"","enable_animation":"1","animationduration":"300","animationdelay":"0","columns_gap":{"xl":"","lg":"","md":"","sm":"","xs":"","unit":"px"},"id":"","class":"","container_width":"","title":"","subtitle":""},"layout":"12","columns":[{"id":"7640e52f-78ce-4923-a808-5490f22313a6","class_name":"row-column","visibility":true,"settings":{"background_type":"none","background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"background_image":{"src":""},"background_repeat":"no-repeat","background_size":"cover","background_size_custom":{"unit":"px"},"background_attachment":"scroll","background_position":"0 0","background_position_custom_x":{"unit":"px"},"background_position_custom_y":{"unit":"px"},"overlay_type":"overlay_color","gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"pattern_overlay":{"src":""},"overlay_pattern_color":"","blend_mode":"normal","use_border":0,"border_width":"","boxshadow":"0 0 0 0 #FFFFFF","items_align_center":0,"items_content_alignment":"center","column_custom_css":"","tablet_order_landscape":"","tablet_order":"","mobile_order_landscape":"","mobile_order":"","hidden_xl":"","hidden_lg":"","hidden_md":"","hidden_sm":"","hidden_xs":"","enable_animation":"1","animationduration":"300","animationdelay":"0","width":{"xl":"100%","lg":"100%","md":"100%","sm":"100%","xs":"100%"}},"addons":[{"id":"371e8628-add3-46f0-8688-e8786186d103","type":"dynamic-content","name":"dynamic_content_image","visibility":true,"title":"Dynamic Media","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M3 8.792C3 6.698 4.712 5 6.824 5h15.295c2.112 0 3.824 1.698 3.824 3.792v6.066a.758.758 0 0 1-.472.7.77.77 0 0 1-.833-.163l-3.23-3.202a.769.769 0 0 0-1.189.134l-5.446 8.64c-.854 1.356-2.814 1.439-3.781.16l-1.885-2.492a.768.768 0 0 0-1.268.064l-3.301 5.455a2.287 2.287 0 0 0 2.286 2.08h7.648c.422 0 .764.339.764.758a.762.762 0 0 1-.764.758H6.824C4.712 27.75 3 26.052 3 23.958V8.792ZM4.53 21.22l1.997-3.302c.839-1.385 2.826-1.487 3.803-.195l1.886 2.493a.768.768 0 0 0 1.26-.053l5.446-8.64a2.306 2.306 0 0 1 3.568-.404l1.924 1.908V8.792a2.285 2.285 0 0 0-2.295-2.275H6.824A2.285 2.285 0 0 0 4.53 8.792V21.22ZM9.118 9.55c-.845 0-1.53.679-1.53 1.517 0 .837.686 1.516 1.53 1.516.845 0 1.53-.679 1.53-1.516 0-.838-.685-1.517-1.53-1.517ZM6.06 11.067c0-1.676 1.37-3.034 3.06-3.034 1.689 0 3.058 1.358 3.058 3.034 0 1.675-1.37 3.033-3.059 3.033-1.69 0-3.059-1.358-3.059-3.033Zm18.579 5.59a.77.77 0 0 1 1.081 0l2.715 2.692.001.002.018.017c.095.093.214.209.303.323.108.14.244.363.244.667 0 .304-.136.527-.244.667-.09.114-.208.23-.303.322l-.018.018-.001.002-2.715 2.69a.77.77 0 0 1-1.081 0 .754.754 0 0 1 0-1.072l1.885-1.869h-5.942c-1.197 0-2.285 1.078-2.285 2.559 0 1.48 1.088 2.558 2.285 2.558h3.05c.422 0 .765.34.765.759a.762.762 0 0 1-.765.758h-3.05c-2.172 0-3.815-1.892-3.815-4.075 0-2.184 1.643-4.076 3.815-4.076h5.942l-1.885-1.869a.754.754 0 0 1 0-1.072Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"item_alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"enable_slider":0,"enable_arrows":0,"slider_style":"thumb","image_per_slide":1,"gallery_width":{"xl":200},"gallery_height":{"xl":200},"gallery_item_gap":{"xl":0},"gallery_border_radius":0,"gallery_heading_selector":"h3","mp4_enable":0,"show_control":1,"video_loop":0,"video_mute":1,"autoplay_video":0,"download_video":1,"show_rel_video":0,"no_cookie":0,"youtube_shorts":0,"vimeo_show_author":0,"vimeo_mute_video":1,"vimeo_show_author_profile":0,"vimeo_show_video_title":0,"image_fit":"cover","is_effects_enabled":0,"attribute":{"id":-6,"name":"Featured Image","fullname":"Articles > Featured Image","type":"image","level":2,"path":"featured_image"},"margin":{"xl":"0px 0px 64px 0px"},"radius":{"xl":"8"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":123}}},{"id":"e837d53e-31df-47f3-a93b-59a32ac5b462","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonId .sppb-dynamic-content-text__icon.fas.fa-circle {\n  margin-top: 1.5px;\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"7px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-16,"name":"Created Date","fullname":"Articles > Created Date","type":"date-time","level":2,"path":"created","date_format":"d M, Y"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":51},"color":"#868686","icon":"fas fa-circle","icon_color":"#474652","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""}},"parent":"48dcb032-84cd-48ee-bced-f6fcc3621d9f"},{"id":"b85517df-7a1f-4e58-98a8-a01c48d89882","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["655912d4-fe7c-474e-bbfd-0a3d7446b15b","f5e1f838-e703-43ca-b6c3-98af4c3e7a4a"],"parent":"48dcb032-84cd-48ee-bced-f6fcc3621d9f"},{"id":"655912d4-fe7c-474e-bbfd-0a3d7446b15b","type":"content","name":"heading","visibility":true,"title":"Heading","icon":"<svg viewBox=\"0 0 32 32\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path d=\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonId span.fas.fa-circle.sppb-addon-title-icon:before {\n  font-size: 7px;\n  vertical-align: middle;\n  margin-right: 4px;\n}\n\n#addonId {\n  transform: translateY(-1.1px);\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"title":"By","heading_selector":"p","title_text_shadow":"0 0 0 transparent","alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"title_icon_position":"before","title_margin":{"xl":"0px 2px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":104},"title_color":{"type":"solid","color":"#868686","color2":"","pos":0,"pos2":100,"deg":0,"radialPos":"center center"},"title_icon":"fas fa-circle","title_icon_color":"#474652","heading_typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""}},"parent":"b85517df-7a1f-4e58-98a8-a01c48d89882"},{"id":"f5e1f838-e703-43ca-b6c3-98af4c3e7a4a","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-17,"name":"Author","fullname":"Articles > Author","type":"text","level":2,"path":"username"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":104},"color":"#868686","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""}},"parent":"b85517df-7a1f-4e58-98a8-a01c48d89882"},{"id":"696d01bb-0806-4258-9504-c49f11f9925d","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-18,"name":"Category","fullname":"Articles > Category","type":"text","level":2,"path":"category"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":104},"color":"#868686","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""}},"parent":"48dcb032-84cd-48ee-bced-f6fcc3621d9f"},{"id":"48dcb032-84cd-48ee-bced-f6fcc3621d9f","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"8px","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["696d01bb-0806-4258-9504-c49f11f9925d","e837d53e-31df-47f3-a93b-59a32ac5b462","b85517df-7a1f-4e58-98a8-a01c48d89882"]},{"id":"d914fcb8-8509-4fd3-9506-afdb7e7ec43d","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":{"xl":"0px 118px 0px 118px","sm":"0px 0px 0px 0px"},"global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonWrapper {\n  width: 100%;\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":0,"hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"column","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible","width":{"xl":""}},"children":["1fd9d68f-e1e8-4b42-b707-a83f871d569b","e1fb2073-3516-4b6a-a59d-3f6fe3dfbf1e","09899845-14da-42b5-89cd-a39d6cb44b64","384a1d35-6c14-4533-b149-00237874a769"],"parent":"e3078979-ae34-4796-a03c-2c9e9b4ac664"},{"id":"e3078979-ae34-4796-a03c-2c9e9b4ac664","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["d914fcb8-8509-4fd3-9506-afdb7e7ec43d"]},{"id":"c463b502-c22c-4ca2-8931-2234a88e3605","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"block","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["0c8a7c9d-1cda-4249-bb2c-ca0f4789d2d9","538013a1-5930-4c30-9c51-5b425563bb8d"]},{"id":"0c8a7c9d-1cda-4249-bb2c-ca0f4789d2d9","type":"content","name":"heading","visibility":true,"title":"Heading","icon":"<svg viewBox=\"0 0 32 32\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path d=\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"title":"YOU MAY ALSO LIKE","heading_selector":"h3","title_text_shadow":"0 0 0 transparent","alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"title_icon_position":"before","title_margin":{"xl":"161px 0px 60px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":117},"heading_typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"","size":{"xl":{"value":"48","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"title_color":{"type":"solid","color":"#474652","color2":"","pos":0,"pos2":100,"deg":0,"radialPos":"center center"}},"parent":"c463b502-c22c-4ca2-8931-2234a88e3605"},{"id":"538013a1-5930-4c30-9c51-5b425563bb8d","type":"dynamic-content","name":"dynamic_content_collection","visibility":true,"title":"Collection","icon":"<svg width=\"32\" height=\"32\" viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.467 6.91c0-.083.059-.309.523-.638.445-.315 1.136-.63 2.056-.906 1.831-.549 4.404-.9 7.278-.9 2.874 0 5.447.351 7.278.9.92.276 1.612.59 2.056.906.464.329.524.555.524.639 0 .083-.06.31-.524.638-.444.316-1.136.63-2.056.906-1.83.55-4.404.9-7.278.9-2.874 0-5.447-.35-7.278-.9-.92-.276-1.611-.59-2.056-.906-.464-.329-.523-.555-.523-.638ZM16.324 3c-2.975 0-5.697.36-7.7.962-.996.298-1.856.669-2.483 1.114C5.533 5.506 5 6.116 5 6.91c0 .033 0 .066.003.099A.74.74 0 0 0 5 7.074h.008H5v16.567c0 .816.477 1.488 1.1 2 .628.516 1.492.948 2.495 1.296 2.012.7 4.745 1.12 7.73 1.12 2.983 0 5.716-.42 7.729-1.12 1.003-.349 1.867-.78 2.494-1.296.623-.512 1.1-1.184 1.1-2V7.075h-.007v-.001h.007a.73.73 0 0 0-.003-.065c.002-.032.003-.065.003-.098 0-.795-.533-1.404-1.141-1.835-.627-.445-1.487-.816-2.483-1.114C22.022 3.36 19.299 3 16.324 3Zm9.858 5.957c-.586.352-1.324.653-2.158.903-2.002.6-4.725.961-7.7.961-2.975 0-5.697-.36-7.7-.961-.833-.25-1.571-.55-2.157-.903v6.771c0 .084.062.31.523.636.445.316 1.136.63 2.056.906 1.831.55 4.404.9 7.278.9 2.874 0 5.447-.35 7.278-.9.92-.276 1.612-.59 2.056-.906.464-.329.524-.555.524-.638V8.957ZM6.467 23.641v-5.868c.586.352 1.324.652 2.158.902 2.002.6 4.724.961 7.7.961 2.974 0 5.697-.36 7.699-.961.834-.25 1.572-.55 2.158-.902v5.868c0 .2-.116.497-.565.867-.444.365-1.131.726-2.045 1.044-1.82.633-4.383 1.037-7.248 1.037s-5.427-.404-7.248-1.037c-.914-.318-1.6-.68-2.045-1.044-.449-.37-.564-.666-.564-.867Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"direction":"asc","filters":"","limit":"2","pagination":0,"pagination_type":"load-more","pagination_load_more_button_text":"Load More","pagination_buttons_position":"start","pagination_load_more_button_type":"primary","display":"grid","grid_columns":{"xl":"2","sm":"1"},"flex_direction":"column","flex_wrap":"wrap","vertical_alignment":"start","horizontal_alignment":"start","column_gap":{"xl":"32"},"row_gap":{"xl":"32"},"item_options":"normal","source":-2,"no_records_message":"","no_records_description":"","item_width":{"xl":""},"link":{"type":"page","url":"","menu":"","page":-2,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":14}},"child_nodes":[{"id":"373a725c-86d5-4a50-8d0e-198439658573","type":"dynamic-content","name":"dynamic_content_image","visibility":true,"title":"Dynamic Media","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M3 8.792C3 6.698 4.712 5 6.824 5h15.295c2.112 0 3.824 1.698 3.824 3.792v6.066a.758.758 0 0 1-.472.7.77.77 0 0 1-.833-.163l-3.23-3.202a.769.769 0 0 0-1.189.134l-5.446 8.64c-.854 1.356-2.814 1.439-3.781.16l-1.885-2.492a.768.768 0 0 0-1.268.064l-3.301 5.455a2.287 2.287 0 0 0 2.286 2.08h7.648c.422 0 .764.339.764.758a.762.762 0 0 1-.764.758H6.824C4.712 27.75 3 26.052 3 23.958V8.792ZM4.53 21.22l1.997-3.302c.839-1.385 2.826-1.487 3.803-.195l1.886 2.493a.768.768 0 0 0 1.26-.053l5.446-8.64a2.306 2.306 0 0 1 3.568-.404l1.924 1.908V8.792a2.285 2.285 0 0 0-2.295-2.275H6.824A2.285 2.285 0 0 0 4.53 8.792V21.22ZM9.118 9.55c-.845 0-1.53.679-1.53 1.517 0 .837.686 1.516 1.53 1.516.845 0 1.53-.679 1.53-1.516 0-.838-.685-1.517-1.53-1.517ZM6.06 11.067c0-1.676 1.37-3.034 3.06-3.034 1.689 0 3.058 1.358 3.058 3.034 0 1.675-1.37 3.033-3.059 3.033-1.69 0-3.059-1.358-3.059-3.033Zm18.579 5.59a.77.77 0 0 1 1.081 0l2.715 2.692.001.002.018.017c.095.093.214.209.303.323.108.14.244.363.244.667 0 .304-.136.527-.244.667-.09.114-.208.23-.303.322l-.018.018-.001.002-2.715 2.69a.77.77 0 0 1-1.081 0 .754.754 0 0 1 0-1.072l1.885-1.869h-5.942c-1.197 0-2.285 1.078-2.285 2.559 0 1.48 1.088 2.558 2.285 2.558h3.05c.422 0 .765.34.765.759a.762.762 0 0 1-.765.758h-3.05c-2.172 0-3.815-1.892-3.815-4.075 0-2.184 1.643-4.076 3.815-4.076h5.942l-1.885-1.869a.754.754 0 0 1 0-1.072Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"item_alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"enable_slider":0,"enable_arrows":0,"slider_style":"thumb","image_per_slide":1,"gallery_width":{"xl":200},"gallery_height":{"xl":200},"gallery_item_gap":{"xl":0},"gallery_border_radius":0,"gallery_heading_selector":"h3","mp4_enable":0,"show_control":1,"video_loop":0,"video_mute":1,"autoplay_video":0,"download_video":1,"show_rel_video":0,"no_cookie":0,"youtube_shorts":0,"vimeo_show_author":0,"vimeo_mute_video":1,"vimeo_show_author_profile":0,"vimeo_show_video_title":0,"image_fit":"cover","is_effects_enabled":0,"attribute":{"id":-6,"name":"Featured Image","fullname":"Articles > Featured Image","type":"image","level":2,"path":"featured_image"},"height":{"xl":"462"},"margin":{"xl":"0px 0px 18px 0px"},"radius":{"xl":"8"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":123}}},{"id":"7475324c-19ea-43ff-8a2e-155d5040b634","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"flex-start","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"8px","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"child_nodes":[{"id":"dab5f065-8473-40c4-9084-d12b05c43956","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-18,"name":"Category","fullname":"Articles > Category","type":"text","level":2,"path":"category"},"color":"#868686","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":89}}},{"id":"2367ee88-c45b-40f5-9dc3-2ef2dc67749c","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"7px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-16,"name":"Created Date","fullname":"Articles > Created Date","type":"date-time","level":2,"path":"created","date_format":"d M, Y"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":48},"color":"#868686","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"14","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"icon":"fas fa-circle","icon_color":"#474652"}}]},{"id":"5cc6e20a-88d4-4492-b51a-7ed6a151cd7e","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"h5","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"10px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-3,"name":"Title","fullname":"Articles > Title","type":"text","level":2,"path":"title"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":48},"typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"700","size":{"xl":{"value":"24","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"color":"#474652"}}],"parent":"c463b502-c22c-4ca2-8931-2234a88e3605"},{"id":"e1fb2073-3516-4b6a-a59d-3f6fe3dfbf1e","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"p","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-4,"name":"Intro Text","fullname":"Articles > Intro Text","type":"rich-text","level":2,"path":"introtext"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":74},"color":"#474652","typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"20","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"30","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"alignment":{"xl":"center"}},"parent":"d914fcb8-8509-4fd3-9506-afdb7e7ec43d"},{"id":"09899845-14da-42b5-89cd-a39d6cb44b64","type":"structure","name":"div","visibility":true,"title":"Div","icon":"<svg xmlns=\"http:\/\/www.w3.org\/2000\/svg\" viewBox=\"0 0 32 32\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\" fill=\"currentColor\"><\/path><path d=\"M19.7 0h-7.3v2.9h7.3V0z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\" fill=\"currentColor\"><\/path><path d=\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\" fill=\"currentColor\"><\/path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\" fill=\"currentColor\"><\/path><path d=\"M19.7 29.1h-7.3V32h7.3v-2.9z\" fill=\"currentColor\"><\/path><\/svg>","settings":{"global_padding":"","global_margin":{"xl":"64px 0px 0px 0px"},"global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"display":"flex","flex_direction":{"xl":"row","lg":"","md":"","sm":"","xs":""},"reverse_direction":{"xl":0,"lg":0,"md":0,"sm":0,"xs":0},"justify_content":{"xl":"center","lg":"","md":"","sm":"","xs":""},"align_items":{"xl":"center","lg":"","md":"","sm":"","xs":""},"flex_wrap":{"xl":"nowrap","lg":"","md":"","sm":"","xs":""},"flex_gap":{"xl":"24px","lg":"","md":"","sm":"","xs":""},"overflow":"visible"},"children":["575850de-765a-4e92-95ff-ec52ed89fdc1","6f2bee4d-60f6-489b-9b8a-933c511ba99f"],"parent":"d914fcb8-8509-4fd3-9506-afdb7e7ec43d"},{"id":"384a1d35-6c14-4533-b149-00237874a769","type":"content","name":"comment","visibility":true,"title":"Comment","icon":"<svg width=\"24\" height=\"25\" viewBox=\"0 0 24 25\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\">\n\t\t\t\t\t\t<path d=\"M7.9668 13.823H12.9974M7.9668 9.63086H10.4821\" stroke=\"#6F7CA3\" stroke-width=\"1.3\" stroke-linecap=\"round\" stroke-linejoin=\"round\"\/>\n\t\t\t\t\t\t<path d=\"M12.1691 5.02051H3.93555C3.38326 5.02051 2.93555 5.46822 2.93555 6.02051V17.4002C2.93555 17.9525 3.38326 18.4002 3.93555 18.4002H6.29105V21.7797C6.29105 21.7867 6.29922 21.7906 6.30471 21.7862L10.4929 18.4002H18.703C19.2553 18.4002 19.703 17.9525 19.703 17.4002V12.5694\" stroke=\"#6F7CA3\" stroke-width=\"1.3\" stroke-linecap=\"round\"\/>\n\t\t\t\t\t\t<ellipse cx=\"17.3784\" cy=\"7.39731\" rx=\"3.68696\" ry=\"3.68686\" fill=\"#6F7CA3\"\/>\n\t\t\t\t\t\t<path d=\"M15.875 7.39743H18.8838M17.3794 5.89307V8.90179\" stroke=\"white\" stroke-width=\"0.8\" stroke-linecap=\"round\" stroke-linejoin=\"round\"\/>\n\t\t\t\t\t\t<\/svg>\n\t\t\t\t\t\t","settings":{"global_padding":"","global_margin":{"xl":"120px 0px 0px 0px"},"global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonWrapper {\n  width: 100%;\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"title_text":"Comments","title_color":"#000000","title_alignment":{"xl":"flex-start","lg":"","md":"","sm":"","xs":""},"comment_count":"1","comment_count_color":"#7A7C85","comment_count_position":"right","enable_label":"1","label_text":"Leave a comment","label_color":"#000000","label_alignment":{"xl":"flex-start","lg":"","md":"","sm":"","xs":""},"comment_field_placeholder":"Share your thoughts...","comment_field_height":88,"comment_field_padding":"16px 16px 16px 16px","comment_field_placeholder_color":"#646E8F","comment_field_typing_color":"#000000","comment_field_background_color":"#FFFFFF","comment_field_background_hover_color":"#FFFFFF","comment_field_placeholder_hover_color":"#7A7C85","comment_field_border_width":"1px 1px 1px 1px","comment_field_border_color":"#D3D7EB","comment_field_border_focus_color":"#3366FF","post_button_text":"Leave a comment","post_button_aria_label":"","enable_anonymous_comment":1,"post_button_type":"default","post_button_appearance":"","post_button_shape":"rounded","post_button_padding":"","post_button_alignment":{"xl":"flex-end","lg":"","md":"","sm":"","xs":""},"post_button_icon_position":"left","post_button_icon_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"post_button_style_state":"normal","post_button_color":"#FFFFFF","post_button_color_hover":"#FFFFFF","post_button_background_color":"#3366FF","post_button_background_color_hover":"#0037DD","post_button_background_gradient":{"color":"#3366FF","color2":"#0037DD","deg":"45","type":"linear"},"post_button_background_gradient_hover":{"color":"#0037DD","color2":"#3366FF","deg":"45","type":"linear"},"post_button_link_style_state":"normal","post_button_link_color":"#3366FF","post_button_link_border_width":1,"post_button_link_border_color":"#3366FF","post_button_link_hover_color":"#0037DD","post_button_link_border_hover_color":"#0037DD","edit_comment_button_item":[{"title":"Cancel"},{"title":"Update"}],"edit_comment_button_gap":10,"edit_comment_button_alignment":{"xl":"flex-end","lg":"","md":"","sm":"","xs":""},"commentator_name_color":"#000000","commentator_avatar_color":"#4285F4","enable_time":1,"time_color":"#7A7C85","show_edited_time":1,"edited_time_color":"#7A7C85","posted_comment_color":"#484F66","ellipsis_button_style":"custom","ellipsis_appearance":"flat","ellipsis_shape":"rounded","ellipsis_size":"","ellipsis_position":"right","ellipsis_style_state":"normal","ellipsis_icon_color":"#6F7CA3","ellipsis_action_button_item":[{"title":"Edit"},{"title":"Delete"}],"enable_likes":"1","likes_color":"#7A7C85","likes_hover_color":"#343D57","likes_focused_color":"#EE563D","likes_icon":"","likes_icon_position":"left","enable_reply":"1","reply_color":"#7A7C85","reply_hover_color":"#343D57","reply_icon":"","reply_icon_position":"left"},"parent":"d914fcb8-8509-4fd3-9506-afdb7e7ec43d"},{"id":"6f2bee4d-60f6-489b-9b8a-933c511ba99f","type":"content","name":"social_share","visibility":true,"title":"Social Share","icon":"<svg viewBox=\"0 0 32 32\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M24.5 2a3.5 3.5 0 100 7 3.5 3.5 0 000-7zM19 5.5a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0zM6.5 12.5a3.5 3.5 0 100 7 3.5 3.5 0 000-7zM1 16a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0zM24.5 23a3.5 3.5 0 100 7 3.5 3.5 0 000-7zM19 26.5a5.5 5.5 0 1111 0 5.5 5.5 0 01-11 0z\" fill=\"currentColor\"\/><path opacity=\".5\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M9.521 17.762a1 1 0 011.367-.361l10.246 5.97a1 1 0 01-1.007 1.728l-10.245-5.97a1 1 0 01-.361-1.367zM21.479 7.261a1 1 0 01-.36 1.368l-10.23 5.97a1 1 0 01-1.008-1.728l10.23-5.97a1 1 0 011.368.36z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":{"xl":"0px 0px 0px 0px"},"global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonId .sppb-social-share-style-custom ul li a i {\n  font-size: 12px;\n\n}\n\n.sppb-social-share-style-custom ul li a {\n  padding: 3.5px 2px 3.5px 2px;\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"show_socials":["facebook","twitter","linkedin"],"show_social_names":0,"social_style":"custom","social_border_radius":"2","icon_align":{"xl":"left","lg":"","md":"","sm":"","xs":""},"color_tab":"hover","icon_color":"#6C63FF","background_color":"#FFFFFF","social_border_width":"1","icon_hover_color":"#FFFFFF","background_hover_color":"#6C63FF","heading_selector":"h3","title":"","title_margin_top":{"xl":""},"social_border_color":"#6C63FF"},"parent":"09899845-14da-42b5-89cd-a39d6cb44b64"},{"id":"575850de-765a-4e92-95ff-ec52ed89fdc1","type":"content","name":"heading","visibility":true,"title":"Heading","icon":"<svg viewBox=\"0 0 32 32\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path d=\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":"","global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"title":"Share with your friends","heading_selector":"p","title_text_shadow":"0 0 0 transparent","alignment":{"xl":"left","lg":"","md":"","sm":"","xs":""},"title_icon_position":"before","title_margin":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 0px 0px 0px","lg":"","md":"","sm":"","xs":""},"title_link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":129},"title_color":{"type":"solid","color":"#868686","color2":"","pos":0,"pos2":100,"deg":0,"radialPos":"center center"},"heading_typography":{"font":"Arial","uppercase":false,"italic":false,"underline":false,"weight":"","size":{"xl":{"value":"16","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""}},"parent":"09899845-14da-42b5-89cd-a39d6cb44b64"},{"id":"1fd9d68f-e1e8-4b42-b707-a83f871d569b","type":"dynamic-content","name":"dynamic_content_text","visibility":true,"title":"Dynamic Text","icon":"<svg viewBox=\"0 0 32 32\" fill=\"none\" xmlns=\"http:\/\/www.w3.org\/2000\/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.611 4.444a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334ZM3 6.611a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0ZM25.389 23.222a2.167 2.167 0 1 0 0 4.334 2.167 2.167 0 0 0 0-4.334Zm-3.611 2.167a3.611 3.611 0 1 1 7.222 0 3.611 3.611 0 0 1-7.222 0Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.778 6.611c0-.399.323-.722.722-.722h14.444c1.197 0 2.167.97 2.167 2.167v10.833a.722.722 0 1 1-1.444 0V8.056a.722.722 0 0 0-.723-.723H9.5a.722.722 0 0 1-.722-.722ZM23.222 25.389a.722.722 0 0 1-.722.722H8.056a2.167 2.167 0 0 1-2.167-2.167V13.111a.722.722 0 1 1 1.444 0v10.833c0 .4.324.723.723.723H22.5c.399 0 .722.323.722.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.99 16.212a.722.722 0 0 1 1.02 0l2.379 2.378 2.378-2.378a.722.722 0 0 1 1.021 1.02l-2.684 2.686a1.011 1.011 0 0 1-1.43 0l-2.685-2.685a.722.722 0 0 1 0-1.021ZM10.01 15.789a.722.722 0 0 1-1.02 0L6.61 13.41 4.233 15.79a.722.722 0 0 1-1.021-1.022l2.684-2.684a1.011 1.011 0 0 1 1.43 0l2.685 2.684a.722.722 0 0 1 0 1.022ZM16 11.667c.399 0 .722.323.722.722v8.667a.722.722 0 0 1-1.444 0v-8.667c0-.399.323-.722.722-.722Z\" fill=\"#6F7CA3\"\/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M21.056 11.667a.722.722 0 0 1-.723.722h-8.666a.722.722 0 1 1 0-1.445h8.666c.4 0 .723.324.723.723Z\" fill=\"currentColor\"\/><\/svg>","settings":{"global_padding":"","global_margin":"","global_background_type":"none","global_background_gradient":{"color":"#00c6fb","color2":"#005bea","deg":"45","type":"linear"},"global_background_image":{"src":""},"global_background_repeat":"no-repeat","global_background_size":"cover","global_background_attachment":"inherit","global_background_position":"50% 50%","global_use_overlay":0,"global_overlay_type":"overlay_none","global_gradient_overlay":{"color":"rgba(127, 0, 255, 0.8)","color2":"rgba(225, 0, 255, 0.7)","deg":"45","type":"linear"},"global_pattern_overlay":{"src":""},"global_overlay_pattern_color":"","blend_mode":"normal","global_user_border":0,"global_border_width":{"xl":"","lg":"","md":"","sm":"","xs":""},"transform":{"move":{"x":{"value":"","unit":"px"},"y":{"value":"","unit":"px"}},"rotate":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"},"z":{"value":"","unit":"deg"}},"scale":{"x":"","y":""},"skew":{"x":{"value":"","unit":"deg"},"y":{"value":"","unit":"deg"}},"transform_origin":{"top":{"value":"50","unit":"%"},"left":{"value":"50","unit":"%"}}},"global_use_animation":0,"global_animationduration":"300","global_animationdelay":"0","global_border_radius":{"xl":"","lg":"","md":"","sm":"","xs":""},"global_boxshadow":"0 0 0 0 #FFFFFF","class":"","global_custom_css":"#addonId {\n  text-align: center\n}","global_custom_position":0,"global_seclect_position":"relative","global_addon_position_left":{"unit":"px"},"global_addon_position_top":{"unit":"px"},"use_global_width":"0","hidden_xl":"0","hidden_lg":"0","hidden_md":"0","hidden_sm":"0","hidden_xs":"0","acl":"","admin_label":"","while_scroll_view":[{"enable_while_scroll_view":0,"scrolling_options":"fullpage","on_scroll_actions":[{"id":"b3fdc1c1e6bfde5942ea","index":0,"keyframe":0,"name":"move","property":{"x":"0","y":"-100","z":"0"},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"},{"id":"936e0225e6dc8edfba7d","index":1,"keyframe":100,"name":"move","property":{"x":0,"y":0,"z":0},"range":{"max":500,"min":-500,"stop":1},"single":true,"title":"Move"}],"transition_origin_x":"center","transition_origin_y":"center","enable_tablet":0,"enable_mobile":0}],"mouse_movement":[{"enable_tilt_effect":0,"mouse_tilt_direction":"direct","mouse_tilt_speed":"1","mouse_tilt_max":"15","enable_tablet":0,"enable_mobile":0}],"default_text":"","selector":"h1","title_text_shadow":"0 0 0 transparent","icon_position":"left","icon_gap":"8px","icon_size":"16px","title_margin":{"xl":"32px 0px 48px 0px","lg":"","md":"","sm":"","xs":""},"title_padding":{"xl":"0px 35px 0px 35px","lg":"","md":"","sm":"","xs":""},"attribute":{"id":-3,"name":"Title","fullname":"Articles > Title","type":"text","level":2,"path":"title"},"link":{"type":"url","url":"","menu":"","page":0,"popup":0,"action":"","is_no_repeat":0,"new_tab":false,"nofollow":false,"noreferrer":false,"noopener":false,"close_popup":89},"typography":{"font":"Arial","uppercase":true,"italic":false,"underline":false,"weight":"400","size":{"xl":{"value":"50","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"line_height":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"letter_spacing":{"xl":{"value":"","unit":"px"},"lg":{"value":"","unit":"px"},"md":{"value":"","unit":"px"},"sm":{"value":"","unit":"px"},"xs":{"value":"","unit":"px"}},"type":"google","preset":""},"color":"#474652"},"parent":"d914fcb8-8509-4fd3-9506-afdb7e7ec43d"}]}],"parent":false}]';
}