<?php
/**
 * @package    Joomla.Language
 *
 * @copyright  (C) 2021 J!German <https://www.jgerman.de>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * modify		dostosowanie do języka polskiego
 */

defined('_JEXEC') or die;

use Joomla\CMS\Installer\InstallerScript;

/**
 * Installation class to perform additional changes during install/uninstall/update
 *
 * @since  4.0.0v1
 */
class Pkg_plPLInstallerScript extends InstallerScript
{
	/**
	 * Extension script constructor.
	 *
	 * @since   4.0.0v1
	 */
	public function __construct()
	{
		// Define the minumum versions to be supported.
		$this->minimumJoomla = '4.0';
		$this->minimumPhp    = '7.2.5';

		$this->deleteFiles = array(
			// Backend
			'/administrator/language/pl-PL/pl-PL.com_actionlogs.ini',
			'/administrator/language/pl-PL/pl-PL.com_actionlogs.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_admin.ini',
			'/administrator/language/pl-PL/pl-PL.com_admin.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_ajax.ini',
			'/administrator/language/pl-PL/pl-PL.com_ajax.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_associations.ini',
			'/administrator/language/pl-PL/pl-PL.com_associations.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_banners.ini',
			'/administrator/language/pl-PL/pl-PL.com_banners.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_cache.ini',
			'/administrator/language/pl-PL/pl-PL.com_cache.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_categories.ini',
			'/administrator/language/pl-PL/pl-PL.com_categories.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_checkin.ini',
			'/administrator/language/pl-PL/pl-PL.com_checkin.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_config.ini',
			'/administrator/language/pl-PL/pl-PL.com_config.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_contact.ini',
			'/administrator/language/pl-PL/pl-PL.com_contact.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_contenthistory.ini',
			'/administrator/language/pl-PL/pl-PL.com_contenthistory.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_content.ini',
			'/administrator/language/pl-PL/pl-PL.com_content.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_cpanel.ini',
			'/administrator/language/pl-PL/pl-PL.com_cpanel.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_fields.ini',
			'/administrator/language/pl-PL/pl-PL.com_fields.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_finder.ini',
			'/administrator/language/pl-PL/pl-PL.com_finder.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_installer.ini',
			'/administrator/language/pl-PL/pl-PL.com_installer.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_joomlaupdate.ini',
			'/administrator/language/pl-PL/pl-PL.com_joomlaupdate.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_languages.ini',
			'/administrator/language/pl-PL/pl-PL.com_languages.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_login.ini',
			'/administrator/language/pl-PL/pl-PL.com_login.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_mailto.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_media.ini',
			'/administrator/language/pl-PL/pl-PL.com_media.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_menus.ini',
			'/administrator/language/pl-PL/pl-PL.com_menus.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_messages.ini',
			'/administrator/language/pl-PL/pl-PL.com_messages.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_modules.ini',
			'/administrator/language/pl-PL/pl-PL.com_modules.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_newsfeeds.ini',
			'/administrator/language/pl-PL/pl-PL.com_newsfeeds.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_plugins.ini',
			'/administrator/language/pl-PL/pl-PL.com_plugins.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_postinstall.ini',
			'/administrator/language/pl-PL/pl-PL.com_postinstall.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_privacy.ini',
			'/administrator/language/pl-PL/pl-PL.com_privacy.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_redirect.ini',
			'/administrator/language/pl-PL/pl-PL.com_redirect.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_tags.ini',
			'/administrator/language/pl-PL/pl-PL.com_tags.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_templates.ini',
			'/administrator/language/pl-PL/pl-PL.com_templates.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_users.ini',
			'/administrator/language/pl-PL/pl-PL.com_users.sys.ini',
			'/administrator/language/pl-PL/pl-PL.com_wrapper.ini',
			'/administrator/language/pl-PL/pl-PL.com_wrapper.sys.ini',
			'/administrator/language/pl-PL/pl-PL.ini',
			'/administrator/language/pl-PL/pl-PL.lib_joomla.ini',
			'/administrator/language/pl-PL/pl-PL.localise.php',
			'/administrator/language/pl-PL/pl-PL.mod_custom.ini',
			'/administrator/language/pl-PL/pl-PL.mod_custom.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_feed.ini',
			'/administrator/language/pl-PL/pl-PL.mod_feed.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_latestactions.ini',
			'/administrator/language/pl-PL/pl-PL.mod_latestactions.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_latest.ini',
			'/administrator/language/pl-PL/pl-PL.mod_latest.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_logged.ini',
			'/administrator/language/pl-PL/pl-PL.mod_logged.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_login.ini',
			'/administrator/language/pl-PL/pl-PL.mod_login.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_menu.ini',
			'/administrator/language/pl-PL/pl-PL.mod_menu.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_multilangstatus.ini',
			'/administrator/language/pl-PL/pl-PL.mod_multilangstatus.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_popular.ini',
			'/administrator/language/pl-PL/pl-PL.mod_popular.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_privacy_dashboard.ini',
			'/administrator/language/pl-PL/pl-PL.mod_privacy_dashboard.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_quickicon.ini',
			'/administrator/language/pl-PL/pl-PL.mod_quickicon.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_sampledata.ini',
			'/administrator/language/pl-PL/pl-PL.mod_sampledata.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_stats_admin.ini',
			'/administrator/language/pl-PL/pl-PL.mod_stats_admin.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_status.ini',
			'/administrator/language/pl-PL/pl-PL.mod_status.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_submenu.ini',
			'/administrator/language/pl-PL/pl-PL.mod_submenu.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_title.ini',
			'/administrator/language/pl-PL/pl-PL.mod_title.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_toolbar.ini',
			'/administrator/language/pl-PL/pl-PL.mod_toolbar.sys.ini',
			'/administrator/language/pl-PL/pl-PL.mod_version.ini',
			'/administrator/language/pl-PL/pl-PL.mod_version.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_actionlog_joomla.ini',
			'/administrator/language/pl-PL/pl-PL.plg_actionlog_joomla.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_cookie.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_cookie.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_gmail.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_gmail.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_joomla.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_joomla.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_ldap.ini',
			'/administrator/language/pl-PL/pl-PL.plg_authentication_ldap.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_captcha_recaptcha.ini',
			'/administrator/language/pl-PL/pl-PL.plg_captcha_recaptcha_invisible.ini',
			'/administrator/language/pl-PL/pl-PL.plg_captcha_recaptcha_invisible.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_captcha_recaptcha.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_confirmconsent.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_confirmconsent.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_contact.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_contact.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_emailcloak.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_emailcloak.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_fields.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_fields.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_finder.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_finder.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_geshi.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_geshi.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_joomla.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_joomla.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_loadmodule.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_loadmodule.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_pagebreak.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_pagebreak.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_pagenavigation.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_pagenavigation.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_vote.ini',
			'/administrator/language/pl-PL/pl-PL.plg_content_vote.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors_codemirror.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors_codemirror.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors_none.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors_none.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors_tinymce.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors_tinymce.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_article.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_article.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_contact.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_contact.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_fields.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_fields.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_image.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_image.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_menu.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_menu.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_module.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_module.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_pagebreak.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_pagebreak.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_readmore.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_readmore.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_weblink.ini',
			'/administrator/language/pl-PL/pl-PL.plg_editors-xtd_weblink.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_extension_joomla.ini',
			'/administrator/language/pl-PL/pl-PL.plg_extension_joomla.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_calendar.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_calendar.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_checkboxes.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_checkboxes.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_color.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_color.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_editor.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_editor.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_image.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_imagelist.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_imagelist.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_image.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_integer.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_integer.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_list.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_list.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_media.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_media.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_radio.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_radio.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_repeatable.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_repeatable.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_sql.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_sql.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_textarea.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_textarea.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_text.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_text.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_url.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_url.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_usergrouplist.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_usergrouplist.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_user.ini',
			'/administrator/language/pl-PL/pl-PL.plg_fields_user.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_categories.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_categories.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_contacts.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_contacts.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_content.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_content.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_newsfeeds.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_newsfeeds.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_tags.ini',
			'/administrator/language/pl-PL/pl-PL.plg_finder_tags.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_folderinstaller.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_folderinstaller.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_packageinstaller.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_packageinstaller.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_urlinstaller.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_urlinstaller.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_webinstaller.ini',
			'/administrator/language/pl-PL/pl-PL.plg_installer_webinstaller.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_actionlogs.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_actionlogs.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_consents.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_consents.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_contact.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_contact.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_content.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_content.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_message.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_message.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_user.ini',
			'/administrator/language/pl-PL/pl-PL.plg_privacy_user.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_eos310.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_eos310.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_extensionupdate.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_extensionupdate.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_joomlaupdate.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_joomlaupdate.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_phpversioncheck.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_phpversioncheck.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_privacycheck.ini',
			'/administrator/language/pl-PL/pl-PL.plg_quickicon_privacycheck.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_sampledata_blog.ini',
			'/administrator/language/pl-PL/pl-PL.plg_sampledata_blog.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_actionlogs.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_actionlogs.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_cache.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_cache.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_debug.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_debug.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_fields.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_fields.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_highlight.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_highlight.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_languagecode.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_languagecode.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_languagefilter.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_languagefilter.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_log.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_logout.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_logout.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_logrotation.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_logrotation.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_log.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_p3p.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_p3p.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_privacyconsent.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_privacyconsent.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_redirect.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_redirect.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_remember.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_remember.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_sef.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_sef.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_sessiongc.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_sessiongc.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_stats.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_stats.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_updatenotification.ini',
			'/administrator/language/pl-PL/pl-PL.plg_system_updatenotification.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_twofactorauth_totp.ini',
			'/administrator/language/pl-PL/pl-PL.plg_twofactorauth_totp.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_twofactorauth_yubikey.ini',
			'/administrator/language/pl-PL/pl-PL.plg_twofactorauth_yubikey.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_contactcreator.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_contactcreator.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_joomla.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_joomla.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_profile.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_profile.sys.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_terms.ini',
			'/administrator/language/pl-PL/pl-PL.plg_user_terms.sys.ini',
			'/administrator/language/pl-PL/pl-PL.tpl_hathor.ini',
			'/administrator/language/pl-PL/pl-PL.tpl_hathor.sys.ini',
			'/administrator/language/pl-PL/pl-PL.tpl_isis.ini',
			'/administrator/language/pl-PL/pl-PL.tpl_isis.sys.ini',
			'/administrator/language/pl-PL/com_csp.ini',
			'/administrator/language/pl-PL/com_csp.sys.ini',			
			'/administrator/language/pl-PL/plg_fields_subfields.ini',			
			'/administrator/language/pl-PL/plg_fields_subfields.sys.ini',					
			
			// Frontend
			'/language/pl-PL/pl-PL.com_ajax.ini',
			'/language/pl-PL/pl-PL.com_config.ini',
			'/language/pl-PL/pl-PL.com_contact.ini',
			'/language/pl-PL/pl-PL.com_content.ini',
			'/language/pl-PL/pl-PL.com_finder.ini',
			'/language/pl-PL/pl-PL.com_mailto.ini',
			'/language/pl-PL/pl-PL.com_media.ini',
			'/language/pl-PL/pl-PL.com_messages.ini',
			'/language/pl-PL/pl-PL.com_newsfeeds.ini',
			'/language/pl-PL/pl-PL.com_privacy.ini',
			'/language/pl-PL/pl-PL.com_tags.ini',
			'/language/pl-PL/pl-PL.com_users.ini',
			'/language/pl-PL/pl-PL.com_wrapper.ini',
			'/language/pl-PL/pl-PL.files_joomla.sys.ini',
			'/language/pl-PL/pl-PL.finder_cli.ini',
			'/language/pl-PL/pl-PL.ini',
			'/language/pl-PL/pl-PL.lib_fof.ini',
			'/language/pl-PL/pl-PL.lib_fof.sys.ini',
			'/language/pl-PL/pl-PL.lib_idna_convert.sys.ini',
			'/language/pl-PL/pl-PL.lib_joomla.ini',
			'/language/pl-PL/pl-PL.lib_joomla.sys.ini',
			'/language/pl-PL/pl-PL.lib_phpass.sys.ini',
			'/language/pl-PL/pl-PL.lib_phputf8.sys.ini',
			'/language/pl-PL/pl-PL.lib_simplepie.sys.ini',
			'/language/pl-PL/pl-PL.localise.php',
			'/language/pl-PL/pl-PL.mod_articles_archive.ini',
			'/language/pl-PL/pl-PL.mod_articles_archive.sys.ini',
			'/language/pl-PL/pl-PL.mod_articles_categories.ini',
			'/language/pl-PL/pl-PL.mod_articles_categories.sys.ini',
			'/language/pl-PL/pl-PL.mod_articles_category.ini',
			'/language/pl-PL/pl-PL.mod_articles_category.sys.ini',
			'/language/pl-PL/pl-PL.mod_articles_latest.ini',
			'/language/pl-PL/pl-PL.mod_articles_latest.sys.ini',
			'/language/pl-PL/pl-PL.mod_articles_news.ini',
			'/language/pl-PL/pl-PL.mod_articles_news.sys.ini',
			'/language/pl-PL/pl-PL.mod_articles_popular.ini',
			'/language/pl-PL/pl-PL.mod_articles_popular.sys.ini',
			'/language/pl-PL/pl-PL.mod_banners.ini',
			'/language/pl-PL/pl-PL.mod_banners.sys.ini',
			'/language/pl-PL/pl-PL.mod_breadcrumbs.ini',
			'/language/pl-PL/pl-PL.mod_breadcrumbs.sys.ini',
			'/language/pl-PL/pl-PL.mod_custom.ini',
			'/language/pl-PL/pl-PL.mod_custom.sys.ini',
			'/language/pl-PL/pl-PL.mod_feed.ini',
			'/language/pl-PL/pl-PL.mod_feed.sys.ini',
			'/language/pl-PL/pl-PL.mod_finder.ini',
			'/language/pl-PL/pl-PL.mod_finder.sys.ini',
			'/language/pl-PL/pl-PL.mod_footer.ini',
			'/language/pl-PL/pl-PL.mod_footer.sys.ini',
			'/language/pl-PL/pl-PL.mod_languages.ini',
			'/language/pl-PL/pl-PL.mod_languages.sys.ini',
			'/language/pl-PL/pl-PL.mod_login.ini',
			'/language/pl-PL/pl-PL.mod_login.sys.ini',
			'/language/pl-PL/pl-PL.mod_menu.ini',
			'/language/pl-PL/pl-PL.mod_menu.sys.ini',
			'/language/pl-PL/pl-PL.mod_random_image.ini',
			'/language/pl-PL/pl-PL.mod_random_image.sys.ini',
			'/language/pl-PL/pl-PL.mod_related_items.ini',
			'/language/pl-PL/pl-PL.mod_related_items.sys.ini',
			'/language/pl-PL/pl-PL.mod_stats.ini',
			'/language/pl-PL/pl-PL.mod_stats.sys.ini',
			'/language/pl-PL/pl-PL.mod_syndicate.ini',
			'/language/pl-PL/pl-PL.mod_syndicate.sys.ini',
			'/language/pl-PL/pl-PL.mod_tags_popular.ini',
			'/language/pl-PL/pl-PL.mod_tags_popular.sys.ini',
			'/language/pl-PL/pl-PL.mod_tags_similar.ini',
			'/language/pl-PL/pl-PL.mod_tags_similar.sys.ini',
			'/language/pl-PL/pl-PL.mod_users_latest.ini',
			'/language/pl-PL/pl-PL.mod_users_latest.sys.ini',
			'/language/pl-PL/pl-PL.mod_whosonline.ini',
			'/language/pl-PL/pl-PL.mod_whosonline.sys.ini',
			'/language/pl-PL/pl-PL.mod_wrapper.ini',
			'/language/pl-PL/pl-PL.mod_wrapper.sys.ini',
			'/language/pl-PL/pl-PL.tpl_beez3.ini',
			'/language/pl-PL/pl-PL.tpl_beez3.sys.ini',
			'/language/pl-PL/pl-PL.tpl_protostar.ini',
			'/language/pl-PL/pl-PL.tpl_protostar.sys.ini',
			'/language/pl-PL/pl-PL.xml',
			'/language/pl-PL/com_messages.ini',			
		);
	}

	/**
	 * Function to perform changes during postflight
	 *
	 * @param   string            $type    The action being performed
	 * @param   ComponentAdapter  $parent  The class calling this method
	 *
	 * @return  void
	 *
	 * @since   4.0.0v1
	 */
	public function postflight($type, $parent)
	{
		$this->removeFiles();
	}
}
