/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '0', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2021-09-16 07:39:19', '0', '2021-09-16 07:39:19', '0', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '0', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '0', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '0', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '0', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '0', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '0', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '0', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '0', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('2', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('8', '1', 'com_content.article'),
('9', '1', 'com_content.article'),
('10', '1', 'com_content.article'),
('11', '1', 'com_content.article'),
('12', '1', 'com_content.article'),
('13', '1', 'com_content.article'),
('14', '1', 'com_content.article'),
('15', '1', 'com_content.article'),
('16', '1', 'com_content.article'),
('17', '1', 'com_content.article'),
('18', '1', 'com_content.article'),
('19', '1', 'com_content.article'),
('20', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(60))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime DEFAULT NULL,
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=655 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('654', 'Super User', 'admin', 'admin@email.com', '$2y$10$rH2ZmagliYKEIxdgCkpT0eV3nvbxvfe57LwMOAkKcb1G4pD9OWSau', '0', '1', '2020-02-09 05:19:57', '2025-10-21 04:06:50', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('654', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/INSERT INTO `#__user_profiles`  VALUES 
('654', 'guidedtour.id.13', '{\"state\":\"skipped\"}', '0'),
('654', 'guidedtour.id.14', '{\"state\":\"delayed\",\"time\":{\"date\":\"2025-10-21 04:06:53.389549\",\"timezone_type\":3,\"timezone\":\"UTC\"}}', '0'),
('654', 'guidedtour.id.15', '{\"state\":\"delayed\",\"time\":{\"date\":\"2025-10-21 04:07:29.154088\",\"timezone_type\":3,\"timezone\":\"UTC\"}}', '0'),
('654', 'joomlatoken.enabled', '1', '2'),
('654', 'joomlatoken.token', 't2qsWvg0YQLJOqlXNj6965zdusMBiVYAigbuNW96X4Y=', '1');
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_mfa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `tries` int(11) NOT NULL DEFAULT 0,
  `last_try` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Multi-factor Authentication settings';
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('1', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/af-ZA_details.xml', '', '', ''),
('2', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '5.3.2.3', '', 'https://update.joomla.org/language/details5/ar-AA_details.xml', '', '', ''),
('3', '2', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/be-BY_details.xml', '', '', ''),
('4', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '5.3.1.4', '', 'https://update.joomla.org/language/details5/bg-BG_details.xml', '', '', ''),
('5', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/ca-ES_details.xml', '', '', ''),
('6', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/zh-CN_details.xml', '', '', ''),
('7', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/zh-TW_details.xml', '', '', ''),
('8', '2', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '5.2.1.1', '', 'https://update.joomla.org/language/details5/hr-HR_details.xml', '', '', ''),
('9', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/cs-CZ_details.xml', '', '', ''),
('10', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/da-DK_details.xml', '', '', ''),
('11', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/nl-NL_details.xml', '', '', ''),
('12', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-AU_details.xml', '', '', ''),
('13', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-CA_details.xml', '', '', ''),
('14', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-NZ_details.xml', '', '', ''),
('15', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-US_details.xml', '', '', ''),
('16', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/et-EE_details.xml', '', '', ''),
('17', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/fi-FI_details.xml', '', '', ''),
('18', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/nl-BE_details.xml', '', '', ''),
('19', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '5.4.0.3', '', 'https://update.joomla.org/language/details5/fr-FR_details.xml', '', '', ''),
('20', '2', '0', 'French, Canada', '', 'pkg_fr-CA', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/fr-CA_details.xml', '', '', ''),
('21', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/ka-GE_details.xml', '', '', ''),
('22', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/de-DE_details.xml', '', '', ''),
('23', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/de-AT_details.xml', '', '', ''),
('24', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/de-LI_details.xml', '', '', ''),
('25', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/de-LU_details.xml', '', '', ''),
('26', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/de-CH_details.xml', '', '', ''),
('27', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/el-GR_details.xml', '', '', ''),
('28', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/hu-HU_details.xml', '', '', ''),
('29', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/it-IT_details.xml', '', '', ''),
('30', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '5.4.0.2', '', 'https://update.joomla.org/language/details5/ja-JP_details.xml', '', '', ''),
('31', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '5.0.0.4', '', 'https://update.joomla.org/language/details5/kk-KZ_details.xml', '', '', ''),
('32', '2', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/ko-KR_details.xml', '', '', ''),
('33', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '5.2.4.1', '', 'https://update.joomla.org/language/details5/lv-LV_details.xml', '', '', ''),
('34', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/lt-LT_details.xml', '', '', ''),
('35', '2', '0', 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', '0', '5.2.3.1', '', 'https://update.joomla.org/language/details5/nb-NO_details.xml', '', '', ''),
('36', '2', '0', 'Pashto Afghanistan', '', 'pkg_ps-AF', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/ps-AF_details.xml', '', '', ''),
('37', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/fa-IR_details.xml', '', '', ''),
('38', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/pl-PL_details.xml', '', '', ''),
('39', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/pt-BR_details.xml', '', '', ''),
('40', '2', '0', 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', '0', '5.2.2.1', '', 'https://update.joomla.org/language/details5/pt-PT_details.xml', '', '', ''),
('41', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/ro-RO_details.xml', '', '', ''),
('42', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '5.3.4.1', '', 'https://update.joomla.org/language/details5/ru-RU_details.xml', '', '', ''),
('43', '2', '0', 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/sr-RS_details.xml', '', '', ''),
('44', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '5.3.3.2', '', 'https://update.joomla.org/language/details5/sr-YU_details.xml', '', '', ''),
('45', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '5.3.4.1', '', 'https://update.joomla.org/language/details5/sk-SK_details.xml', '', '', ''),
('46', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/sl-SI_details.xml', '', '', ''),
('47', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/es-ES_details.xml', '', '', ''),
('48', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/sv-SE_details.xml', '', '', ''),
('49', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/ta-IN_details.xml', '', '', ''),
('50', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '5.4.0.1', '', 'https://update.joomla.org/language/details5/th-TH_details.xml', '', '', ''),
('51', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '5.4.0.2', '', 'https://update.joomla.org/language/details5/tr-TR_details.xml', '', '', ''),
('52', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '5.4.0.2', '', 'https://update.joomla.org/language/details5/uk-UA_details.xml', '', '', ''),
('53', '2', '0', 'Urdu, Pakistan', '', 'pkg_ur-PK', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/ur-PK_details.xml', '', '', ''),
('54', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '5.3.4.1', '', 'https://update.joomla.org/language/details5/cy-GB_details.xml', '', '', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('2', '802'),
('2', '10035'),
('3', '28'),
('208', '10223'),
('209', '10004'),
('210', '10046'),
('211', '10127'),
('212', '10000'),
('213', '10220'),
('214', '10222'),
('215', '10212');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'tuf', 'https://update.joomla.org/cms/', '1', '1761019671', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_5.xml', '1', '1761019671', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1761019671', '', NULL, NULL),
('208', 'SP Simple Portfolio Module', 'extension', 'http://www.joomshaper.com/updates/mod-sp-simple-portfolio.xml', '1', '1761019672', '', NULL, NULL),
('209', 'System - Helix Ultimate Framework', 'extension', 'http://www.joomshaper.com/updates/plg-system-helixultimate.xml', '1', '1761019672', '', NULL, NULL),
('210', 'shaper_helixultimate', 'extension', 'https://www.joomshaper.com/updates/shaper-helixultimate.xml', '1', '1761019672', '', NULL, NULL),
('211', 'FF Explorer', 'extension', 'https://raw.githubusercontent.com/trananhmanh89/ff-update-server/master/com_ffexplorer.xml', '1', '1761019672', '', NULL, NULL),
('212', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro-next.xml', '1', '1761019672', '', NULL, NULL),
('213', 'SP Easy Image Gallery', 'extension', 'https://www.joomshaper.com/updates/com-sp-easyimagegallery.xml', '1', '1761019672', '', NULL, NULL),
('214', 'SP Simple Portfolio', 'extension', 'http://www.joomshaper.com/updates/com-sp-simple-portfolio.xml', '1', '1761019673', '', NULL, NULL),
('215', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1761019673', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT 0,
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('13', 'shaper_helixultimate', '0', '1', 'shaper_helixultimate - Default', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo2.png\",\"retina_logo\":\"images\\/logo2.png\",\"mobile_logo\":\"images\\/logo2.png\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"40px\",\"logo_height_sm\":\"36px\",\"logo_height_xs\":\"36px\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"\",\"predefined_header\":\"1\",\"header_style\":\"3-MinimalLayout\",\"header_height\":\"60px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"#\",\"twitter\":\"#\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"#\",\"behance\":\"\",\"youtube\":\"#\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"+228 872 4444\",\"contact_mobile\":\"+775 872 4444\",\"contact_email\":\"contact@email.com\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2025-01-01 00:00:00\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"images\\/lo1ex.png\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"preset\\\":\\\"preset1\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#ffffff\\\",\\\"link_color\\\":\\\"#2C5F2D\\\",\\\"link_hover_color\\\":\\\"#fff\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#03a83a\\\",\\\"topbar_text_color\\\":\\\"#ffffff\\\",\\\"logo_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_text_color\\\":\\\"#03a83a\\\",\\\"menu_text_hover_color\\\":\\\"#030000\\\",\\\"menu_text_active_color\\\":\\\"#063803\\\",\\\"menu_dropdown_bg_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2C5F2D\\\",\\\"footer_bg_color\\\":\\\"#2C5F2D\\\",\\\"footer_text_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#2b2b2b\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"hide_mobile\\\":1,\\\"hide_large_mobile\\\":1,\\\"hide_tablet\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":12,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"title\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"left\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+3+3+3\\\",\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"Bottom\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"column_type\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"column_type\\\":0,\\\"name\\\":\\\"bottom2\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom3\\\",\\\"custom_class\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom4\\\",\\\"custom_class\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"grid_size\\\":3}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"6+6\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Footer\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":6,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":6}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-up\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"enable_body_font\":\"1\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Roboto\\\",\\\"fontSize\\\":\\\"1em\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Roboto\\\",\\\"fontSize\\\":\\\"1em\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"600X340\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"blog_list_type\":\"default\",\"blog_details_image\":\"default\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"13\",\"template\":\"shaper_helixultimate\",\"client_id\":\"0\",\"home\":\"1\",\"title\":\"shaper_helixultimate - Default\"}', '0', ''),
('14', 'atum', '1', '1', 'Atum - Default', '{\"hue\": \"hsl(214, 63%, 20%)\", \"bg-light\": \"#f0f4fb\", \"text-dark\": \"#495057\", \"text-light\": \"#ffffff\", \"link-color\": \"#2a69b8\", \"special-color\": \"#001b4c\", \"monochrome\": \"0\", \"loginLogo\": \"\", \"loginLogoAlt\": \"\", \"logoBrandLarge\": \"\", \"logoBrandLargeAlt\": \"\", \"logoBrandSmall\": \"\", \"logoBrandSmallAlt\": \"\", \"colorScheme\": \"os\"}', '1', ''),
('15', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '{}', '1', '');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT 0,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_overrides`  VALUES 
('144', 'shaper_helixultimate', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0LnBocA==', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('145', 'shaper_helixultimate', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9hcnRpY2xlcy5waHA=', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('146', 'shaper_helixultimate', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('147', 'shaper_helixultimate', 'L2h0bWwvY29tX3RhZ3MvdGFncy9kZWZhdWx0X2l0ZW1zLnBocA==', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('148', 'shaper_helixultimate', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9naW4ucGhw', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('149', 'shaper_helixultimate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2F1dGhvci5waHA=', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('150', 'shaper_helixultimate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdC9nbG9iYWwucGhw', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22'),
('151', 'shaper_helixultimate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdC9wYXJhbXMucGhw', '10046', '1', 'Joomla Update', '0', '2025-10-21 04:07:22', '2025-10-21 04:07:22');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '15', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '654', '2020-02-09 05:19:57', '', '654', '2020-02-09 05:19:57', '', '', '0', '*', '1', NULL, NULL),
('2', '1', '1', '2', '1', 'animations', 'Animations', 'animations', '', '', '1', NULL, '2018-02-26 06:42:28', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57'),
('3', '1', '3', '4', '1', 'builder', 'Builder', 'builder', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57'),
('4', '1', '5', '6', '1', 'dropdown', 'Dropdown', 'dropdown', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57'),
('5', '1', '7', '8', '1', 'drag', 'Drag', 'drag', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57'),
('6', '1', '9', '10', '1', 'drop', 'Drop', 'drop', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57'),
('7', '1', '11', '12', '1', 'mega-menu', 'Mega Menu', 'mega-menu', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57'),
('8', '1', '13', '14', '1', 'features', 'Features', 'features', '', '', '1', NULL, '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '654', '2020-02-09 05:19:57', '', '0', '2020-02-09 05:19:57', '{}', '{}', '0', '*', '1', '2020-02-09 05:19:57', '2020-02-09 05:19:57');
/**ABDB**/CREATE TABLE `#__spsimpleportfolio_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__spsimpleportfolio_tags`  VALUES 
('1', 'Home', 'home'),
('2', 'Office', 'office'),
('3', 'Outdoor', 'outdoor');
/**ABDB**/CREATE TABLE `#__spsimpleportfolio_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(55) NOT NULL,
  `catid` int(11) NOT NULL,
  `image` text NOT NULL,
  `thumbnail` text NOT NULL,
  `video` text NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `client` varchar(100) NOT NULL,
  `client_avatar` text NOT NULL,
  `tagids` text NOT NULL,
  `url` text NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int(5) NOT NULL DEFAULT 1,
  `ordering` int(10) NOT NULL DEFAULT 0,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__spsimpleportfolio_items`  VALUES 
('1', 'Visualize impactful mindshare', 'visualize-impactful-mindshare', '0', 'images/spsimpleportfolio/portfolio1.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:13:49', '0', '0000-00-00 00:00:00', NULL, NULL),
('2', 'Enable value-added convergence', 'enable-value-added-convergence', '0', 'images/spsimpleportfolio/portfolio2.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"2\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:21:28', '0', '0000-00-00 00:00:00', NULL, NULL),
('3', 'Visualize vertical interfaces', 'visualize-vertical-interfaces', '0', 'images/spsimpleportfolio/portfolio3.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:50:28', '0', '0000-00-00 00:00:00', NULL, NULL),
('4', 'Integrate clicks-and-mortar methodologies', 'integrate-clicks-and-mortar-methodologies', '0', 'images/spsimpleportfolio/portfolio4.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"3\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:52:48', '0', '0000-00-00 00:00:00', NULL, NULL),
('5', 'Streamline customized models', 'streamline-customized-models', '0', 'images/spsimpleportfolio/portfolio5.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"3\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 08:59:50', '0', '0000-00-00 00:00:00', NULL, NULL),
('6', 'Architect ubiquitous deliverables', 'architect-ubiquitous-deliverables', '0', 'images/spsimpleportfolio/portfolio6.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 09:01:08', '0', '0000-00-00 00:00:00', NULL, NULL),
('7', 'Repurpose viral metrics', 'repurpose-viral-metrics', '0', 'images/spsimpleportfolio/portfolio7.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"1\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 09:02:35', '0', '0000-00-00 00:00:00', NULL, NULL),
('8', 'Matrix holistic deliverables', 'matrix-holistic-deliverables', '0', 'images/spsimpleportfolio/portfolio8.jpg', '', '', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown.</p>\r\n<p><strong>Intro</strong><br />Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.</p>\r\n<p> <br /><strong>Case Study</strong><br />Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.</p>', 'JoomShaper', '', '[\"2\"]', 'http://www.joomshaper.com', '1', '*', '1', '0', '871', '2018-02-22 09:04:02', '0', '0000-00-00 00:00:00', NULL, NULL);
/**ABDB**/CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `section` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_sections`  VALUES 
('1', '3images', '{\"id\":1578670002710,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"four images\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"47px 0px 51px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"rgba(225, 225, 225, 0)\",\"color2\":\"#f2f2f2\",\"deg\":\"180\",\"type\":\"linear\",\"pos2\":\"48\",\"pos\":\"33\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":1,\"shape_name\":\"turning-slope\",\"shape_color\":\"#cecece\",\"shape_width\":{\"md\":\"100\",\"sm\":100,\"xs\":100},\"shape_height\":{\"md\":\"34\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1578670002710,\"id\":\"four_images\",\"row_border\":0,\"background_color\":\"#e8e8e8\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1578670002707,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1578670622038,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images/2020/04/06/widok-z-przodu-kolegow-daje-piatke_23-2148427134.jpg\",\"height\":391,\"width\":626},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 165, 255, 0.8)\",\"color2\":\"rgba(5, 5, 117, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Certified Teachers\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"22\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"md\":\"10px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"100\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578670622038,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fas fa-rocket\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeIn\",\"title_text_color\":\"\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\"}}]},{\"id\":1578670002708,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1586193159765,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"This is title\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"1\",\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"\",\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"100\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586193159765,\"title_font_family\":\"Play\",\"global_text_color\":\"#8c8c8c\",\"global_animation\":\"fadeInDown\"}},{\"id\":1578734839125,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images/2020/04/06/biznes-druzyna-dyskutuje-ich-pomysly-podczas-gdy-pracujacy-w-biurze_171337-5952.jpg\",\"height\":408,\"width\":626},\"image_height\":300,\"background_image_animation\":\"slide-right\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 165, 255, 0.8)\",\"color2\":\"rgba(5, 5, 117, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(124, 255, 0, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Special Education\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"22\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"md\":\"10px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"400\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578734839125,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fa fa-comment\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeIn\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"title_text_color\":\"\"}}]},{\"id\":1578670002709,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1578734839132,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images/2020/04/06/biznesmeni-dyskutuje-strategie-w-spotkaniu-z-whiteboard_1153-4221.jpg\",\"height\":417,\"width\":626},\"image_height\":300,\"background_image_animation\":\"slide-top\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 165, 255, 0.8)\",\"color2\":\"rgba(5, 5, 117, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(255, 101, 0, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Book & Library\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"22\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"md\":\"10px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px  0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"800\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578734839132,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fa fa-book\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeIn\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"title_text_color\":\"\"}}]}]}', '0', '2020-04-06 19:21:02', '654');
/**ABDB**/CREATE TABLE `#__sppagebuilder_presets` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `addon_name` varchar(255) NOT NULL DEFAULT '',
  `preset` mediumtext NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_fonts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `family_name` varchar(100) NOT NULL DEFAULT '',
  `data` text DEFAULT NULL,
  `type` enum('google','local') DEFAULT 'google',
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `family_name` (`family_name`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_colors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `colors` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_assets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `assets` text NOT NULL,
  `css_path` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `code` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addonlist` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `ordering` int(5) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `is_favorite` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `content` mediumtext DEFAULT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `catid` int(10) NOT NULL DEFAULT 0,
  `access` int(10) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_on` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  `checked_out` int(10) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT 0,
  `css` longtext NOT NULL,
  `version` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('1', '60', 'Home', '[{\"id\":1586168484247,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"show_top_shape\":1,\"shape_name\":\"turning-slope\",\"shape_color\":\"#000000\",\"shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":1,\"show_bottom_shape\":1,\"bottom_shape_name\":\"turning-slope\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"163\",\"xl\":\"163\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586168484247,\"slider_settings\":\"slider_global\",\"controllers\":\"dot\",\"row_border\":0,\"columns_content_alignment\":\"center\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1586168484299,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586168484299,\"slider_settings\":\"slider_global\",\"padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"column_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"addons\":[{\"id\":1586168484300,\"name\":\"js_slideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"slider_settings\":\"slider_global\",\"height\":\"custom\",\"custom_height\":{\"xxl\":\"600\",\"xl\":\"600\",\"lg\":600,\"md\":600,\"sm\":\"550\",\"xs\":\"550\"},\"slider_animation\":\"fade\",\"slide_vertically\":1,\"three_d_rotate\":15,\"autoplay\":1,\"interval\":5,\"speed\":800,\"timer\":0,\"timer_position\":\"bottom\",\"timer_bg_color\":\"rgba(0, 0, 0, 0)\",\"class\":\"\",\"controllers\":\"dot\",\"dot_controllers\":1,\"dot_controllers_style\":\"line\",\"line_indecator\":1,\"dot_controllers_position\":\"vertical_right\",\"dot_controllers_bottom_gap\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controllers_left_gap\":{\"xxl\":\"791\",\"xl\":\"791\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controllers_right_gap\":{\"xxl\":\"2068\",\"xl\":\"2068\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controller_style_option\":\"dot_active\",\"dot_ctlr_height\":\"3\",\"dot_ctlr_width\":\"\",\"dot_ctlr_bg\":\"\",\"dot_ctlr_border_width\":\"\",\"dot_ctlr_border_color\":\"\",\"dot_ctlr_border_radius\":\"0\",\"dot_ctlr_margin\":\"   \",\"dot_ctlr_center_bg\":\"#ffffff\",\"dot_ctlr_hover_height\":\"1\",\"dot_ctlr_hover_width\":\"48\",\"dot_ctlr_hover_border_color\":\"\",\"arrow_controllers\":0,\"arrow_on_hover\":0,\"arrow_controllers_style\":\"spread\",\"arrow_controllers_content\":\"icon_only\",\"arrow_controllers_position\":\"bottom_center\",\"arrow_controllers_bottom_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_controllers_left_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_spread_controllers_left_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_spread_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_style\":\"arrow_normal\",\"arrow_ctlr_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_color\":\"\",\"arrow_ctlr_font_size\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_background\":\"\",\"arrow_ctlr_border_width\":\"\",\"arrow_ctlr_border_color\":\"\",\"arrow_ctlr_border_radius\":\"\",\"arrow_ctlr_hover_background\":\"\",\"arrow_ctlr_hover_color\":\"\",\"arrow_ctlr_hover_border_color\":\"\",\"content_container_width\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"85\",\"md\":\"85\",\"sm\":\"95\",\"xs\":\"95\"},\"content_vertical_alignment\":1,\"slideshow_items\":[{\"title\":\"slide 1\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/16\\/sl1.jpg\",\"height\":835,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR \",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 125, 0, 0.75)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}},{\"title\":\"slide 2\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/17\\/sl3.jpg\",\"height\":835,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR \",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 141, 0, 0.86)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}},{\"title\":\"slide 3\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/16\\/sl2.jpg\",\"height\":795,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR\",\"content_tabs\":\"content_animation\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"left\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 141, 0, 0.86)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}},{\"title\":\"slide 4\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/17\\/sl4.jpg\",\"height\":835,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR\",\"content_tabs\":\"content_animation\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"zoom\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"   \",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overaly\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 141, 0, 0.86)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}}],\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0 0  0\",\"xl\":\"0 0  0\",\"lg\":\"0 0 20px 0\",\"md\":\"0 0 20px 0\",\"sm\":\"0 0 10px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"1\",\"blur\":\"12\",\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.55)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1586168484300,\"global_background_color\":\"#000000\",\"timer_color\":\"#F5A623\",\"slide_counter\":0,\"content_container_option\":\"custom\",\"pause_on_hover\":0,\"text_thumb_ctlr_wrap_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_thumb_cont_style\":\"thumb_number\",\"title_content_title\":\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tCorabell&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\"},\"title\":\"Slideshow\",\"icon\":\"<svg viewbox=\\\"0 0 32 32\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M17.656 10.518a1.138 1.138 0 1 0 0 2.276 1.138 1.138 0 0 0 0-2.276ZM15 11.656a2.656 2.656 0 1 1 5.312 0 2.656 2.656 0 0 1-5.312 0ZM10 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm12 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm-6.636-9.909c.885.842 1.854 1.306 2.88 1.345 1.014.038 1.939-.343 2.738-.91 1.563-1.108 2.888-3.095 3.906-5.067l-1.776-.918c-.985 1.906-2.13 3.533-3.287 4.354-.561.398-1.06.56-1.505.543-.433-.017-.96-.207-1.578-.796-1.163-1.106-2.319-1.737-3.458-1.923-1.157-.188-2.186.101-3.042.63-1.648 1.018-2.698 2.941-3.185 4.318l1.886.666c.42-1.19 1.265-2.612 2.35-3.282.511-.316 1.058-.457 1.67-.358.628.102 1.432.477 2.4 1.398Z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M9 8h14v11H9V8ZM7 8a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2V8Zm-2.193 2.591A1 1 0 1 0 3.193 9.41L.236 13.444a1.246 1.246 0 0 0 0 1.46l2.703 3.687a1 1 0 1 0 1.613-1.182L2.18 14.174l2.626-3.583ZM16 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM27.409 9.193a1 1 0 0 1 1.398.216l2.957 4.035c.315.43.315 1.03 0 1.46l-2.703 3.687a1 1 0 1 1-1.613-1.182l2.371-3.235-2.626-3.583a1 1 0 0 1 .216-1.398Z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1578670002710,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"four images\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"2px 0px 121px 2px\",\"xl\":\"2px 0px 121px 2px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"-70px   \",\"xl\":\"-70px   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#ffffff\",\"color2\":\"#dcdcdc\",\"deg\":\"180\",\"type\":\"linear\",\"pos2\":\"48\",\"pos\":\"0\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":0,\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.8)\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"turning-slope\",\"shape_color\":\"rgba(206, 206, 206, 0.61)\",\"shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"34\",\"xl\":\"34\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":1,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"47\",\"xl\":\"47\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1578670002710,\"id\":\"four_images\",\"row_border\":0,\"background_color\":\"\",\"background_video_mp4\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1578670002707,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1578670622038,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/mining-440743_640.jpg\",\"height\":480,\"width\":640},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.72)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.75)\",\"color2\":\"rgba(10, 10, 10, 0.7)\",\"deg\":\"183\",\"type\":\"linear\",\"pos\":\"33\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Mechanical Engineering\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do  eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"10PX 10PX 10PX 10PX\",\"xl\":\"10PX 10PX 10PX 10PX\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"100\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578670622038,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fas fa-rocket\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInLeft\",\"title_text_color\":\"\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"global_background_color\":\"#ffffff\"},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1578670002708,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1578734839125,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/large-hydraulic-excavator-2576750_640.jpg\",\"height\":502,\"width\":640},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(0, 0, 0, 0.7)\",\"deg\":\"7\",\"type\":\"linear\",\"pos2\":\"52\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(124, 255, 0, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Automotive Manufacturing\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do  eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"10PX 10PX 10PX 10PX\",\"xl\":\"10PX 10PX 10PX 10PX\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"300\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578734839125,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fa fa-comment\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInDown\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"title_text_color\":\"\",\"global_background_color\":\"#ffffff\"},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1578670002709,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1578734839132,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/excavator-2771230_640.jpg\",\"height\":426,\"width\":640},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(130, 255, 0, 0.8)\",\"color2\":\"rgba(11, 11, 11, 0.7)\",\"deg\":\"360\",\"type\":\"linear\",\"pos\":\"0\",\"pos2\":\"66\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(255, 101, 0, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Petrol & Gas Engineering\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"sub_title\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do  eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"10PX 10PX 10PX 10PX\",\"xl\":\"10PX 10PX 10PX 10PX\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578734839132,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fa fa-book\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInRight\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"title_text_color\":\"\",\"global_background_color\":\"#ffffff\"},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592380677128,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"80px 0px 102px 0px\",\"xl\":\"80px 0px 102px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/04\\/14\\/18647.jpg\",\"height\":3529,\"width\":5040},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"custom\",\"background_size_custom\":{\"xxl\":\"1289\",\"xl\":\"1289\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"100% 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592380677128,\"background_color\":\"#000000\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1592380677126,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592381195374,\"name\":\"animated_heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"heading_style\":\"highlighted\",\"heading_before_part\":\"EXCEVATOR\",\"highlighted_text\":\"CAT 365C\",\"highlighted_shape\":\"square\",\"shape_color\":\"#efa000\",\"shape_width\":\"4\",\"shape_radius\":0,\"animated_text\":\"awesome\\nnice\\ncool\",\"text_animation_name\":\"clip\",\"heading_after_part\":\"\",\"heading_selector\":\"h2\",\"style_options\":\"animated\",\"heading_fontsize\":{\"xxl\":\"38\",\"xl\":\"38\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"heading_lineheight\":\"\",\"heading_letterspace\":\"\",\"heading_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"heading_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"animated_text_fontsize\":{\"xxl\":\"53\",\"xl\":\"53\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"animated_text_letterspace\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 10px 0px\",\"xl\":\"0px 0px 10px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592381195374,\"animated_text_color\":\"#ffffff\",\"heading_color\":\"#ff9700\",\"highlighted_text_font_family\":\"Anton\",\"heading_font_family\":\"Anton\",\"global_animation\":\"bounceIn\"},\"title\":\"Animated Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M18.2 12c-2.1.3-4.1 2.1-5.5 4.4C10.8 11.3 7.1 7 2.5 7c-.4 0-.8 0-1.1.1-.8.1-1.4.8-1.4 1.6 0 1 .9 1.7 1.9 1.6.2-.1.4-.1.6-.1 4.3 0 8.2 7 8.2 13.1 0 .8.6 1.5 1.3 1.6 1.1.2 2-.6 2-1.6 0-3.1 2.3-7.3 4.3-8-.1-.6-.2-1.2-.2-1.8 0-.6 0-1 .1-1.5z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M26.3 19.3c3.2 0 5.7-2.6 5.7-5.7s-2.6-5.7-5.7-5.7-5.7 2.6-5.7 5.7 2.5 5.7 5.7 5.7z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592381349133,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"500\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592381349133,\"global_text_color\":\"#ffffff\",\"global_animation\":\"fadeIn\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592381856243,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Read More \",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"outline\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"hover\",\"background_color\":\"#ffffff\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"rgba(255, 255, 255, 0.07)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592381856243,\"icon\":\"fas fa-house-damage\",\"font_family\":\"Anton\",\"shape\":\"square\",\"url\":\"https:\\/\\/diablodesign.eu\\/\",\"global_animation\":\"fadeInLeftBig\"},\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592380677127,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592380908830,\"name\":\"video\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=4Y31MD36xF4\",\"show_rel_video\":0,\"no_cookie\":0,\"mp4_enable\":0,\"mp4_video\":{\"src\":\"https:\\/\\/www.joomshaper.com\\/media\\/videos\\/2017\\/11\\/10\\/pb-intro-video.mp4\"},\"ogv_video\":{\"src\":\"\"},\"video_poster\":{\"src\":\"https:\\/\\/www.joomshaper.com\\/images\\/2017\\/11\\/10\\/real-time-frontend.jpg\"},\"show_control\":1,\"video_loop\":0,\"video_mute\":1,\"autoplay_video\":0,\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"0\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":\"9\",\"color\":\"#ffffff\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592380908830,\"global_background_color\":\"#ffffff\",\"global_animation\":\"bounceInRight\"},\"title\":\"Video\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><g opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" fill=\\\"currentColor\\\"><path d=\\\"M30.1 22.1H1.9c-.5 0-.9.4-.9.9s.4 1 .9 1H8v6.1c0 .5.5.9 1 .9s.9-.4.9-.9V24h5.2v6.1c0 .5.4.9.9.9s.9-.4.9-.9V24h5.2v6.1c0 .5.4.9.9.9s.9-.4.9-.9V24H30c.5 0 .9-.4.9-.9.1-.6-.3-1-.8-1zM1.9 9.9H30c.6 0 1-.4 1-.9s-.4-1-.9-1H24V1.9c0-.5-.5-.9-1-.9s-.9.4-.9.9V8h-5.2V1.9c0-.5-.4-.9-.9-.9s-.9.4-.9.9V8H9.9V1.9c0-.5-.4-.9-.9-.9s-1 .4-1 .9V8H1.9c-.5 0-.9.5-.9 1s.4.9.9.9z\\\"\\/><\\/g><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.1 27.6c0 1.2 1 2.2 2.2 2.2h23.2c1.2 0 2.2-1 2.2-2.2V4.4c0-1.2-1-2.2-2.2-2.2H4.4c-1.2 0-2.2 1-2.2 2.2v23.2h-.1zm2.3 4.2c-2.3 0-4.2-1.9-4.2-4.2V4.4C.2 2 2 .2 4.4.2h23.2c2.3 0 4.2 1.9 4.2 4.2v23.2c0 2.3-1.9 4.2-4.2 4.2H4.4z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.5 15c.6.5.6 1.5 0 1.9l-3.9 2.8c-.7.5-1.7 0-1.7-1V13c0-.9 1-1.5 1.7-1l3.9 3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592385112050,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"38px 0px 0px 0px\",\"xl\":\"38px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"video\",\"background_gradient\":{\"color\":\"#4b4b4b\",\"color2\":\"#ffffff\",\"deg\":\"174\",\"type\":\"linear\",\"pos2\":\"64\",\"pos\":\"0\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_mp4\":{\"src\":\"media\\/videos\\/2020\\/06\\/16\\/construction-site---10877.mp4\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"#ffffff\",\"color2\":\"rgba(255, 255, 255, 0.81)\",\"deg\":\"360\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":1,\"shape_name\":\"brushed\",\"shape_color\":\"#000000\",\"shape_width\":{\"xxl\":\"140\",\"xl\":\"140\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"66\",\"xl\":\"66\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"232\",\"xl\":\"232\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"57\",\"xl\":\"57\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":0,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592385112050,\"overlay\":\"rgba(255, 255, 255, 0.94)\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1592385112048,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592393330535,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/06\\/17\\/sk130lc-11_na_cob.png\",\"height\":700,\"width\":800},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"-110px 0px 30px 0px\",\"xl\":\"-110px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":53,\"name\":\"move\",\"property\":{\"x\":\"1\",\"y\":\"-8\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":23,\"name\":\"move\",\"property\":{\"x\":\"-392\",\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592393330535,\"image_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592385112049,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592394736441,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"KOBELCO EXCEVATOR\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"99\",\"xl\":\"99\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"-70px 0px 10PX 0px\",\"xl\":\"-70px 0px 10PX 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":\"6\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":0,\"color\":\"#fff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"900\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592394736441,\"title_font_family\":\"Anton\",\"global_animation\":\"bounceInUp\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592385112178,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.<\\/p>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"500\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592385112178,\"global_text_color\":\"#000000\",\"global_animation\":\"fadeIn\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592395370596,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Read More\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#000000\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#ffffff\",\"background_color_hover\":\"rgba(0, 0, 0, 0.43)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592395370596,\"size\":\"lg\",\"shape\":\"square\",\"font_family\":\"Anton\"},\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592723338889,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"Pricing Table 03\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"14px 0px 0px 0px\",\"xl\":\"14px 0px 0px 0px\",\"lg\":\"100px 0px 100px 0px\",\"md\":\"100px 0px 100px 0px\",\"sm\":\"50px 0px 30px 0px\",\"xs\":\"50px 0px 30px 0px\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"custom\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"external_background_video\":\"0\",\"show_top_shape\":1,\"shape_name\":\"brushed\",\"shape_color\":\"#ffffff\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"53\",\"xl\":\"53\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#060606\",\"color\":\"#fff\",\"instFormId\":1592723338889,\"row_border\":0,\"background_type\":\"image\",\"overlay_type\":\"overlay_color\",\"background_size_custom\":{\"xxl\":\"2911\",\"xl\":\"2911\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1592723338925,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592724929605,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Equipment work\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"69\",\"xl\":\"69\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\" 0px  0px\",\"xl\":\" 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":\"02\",\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592724929605,\"global_text_color\":\"#343434\",\"title_font_family\":\"Anton\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592723338927,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"text_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"22\",\"xs\":\"22\"},\"dropcap\":0,\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 40px 0px\",\"xl\":\"0px 0px 40px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_text_color\":\"#bcbcbc\",\"instFormId\":1592723338927},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1592723338928,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592723340519,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"86px 0px 98px 0px\",\"xl\":\"86px 0px 98px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_mp4\":{\"src\":\"media\\/videos\\/2020\\/06\\/16\\/construction-site---10877.mp4\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"#ffffff\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"360\",\"type\":\"linear\",\"pos2\":\"65\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":{\"ho\":\"0\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":\"0\",\"color\":\"\",\"inset\":false},\"show_top_shape\":0,\"shape_name\":\"brushed\",\"shape_color\":\"#000000\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"75\",\"xl\":\"75\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592723340519,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1592723340517,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592739441484,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/large-hydraulic-excavator-2576750_640.jpg\",\"height\":502,\"width\":640},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"16\",\"vo\":\"20\",\"blur\":\"0\",\"spread\":\"0\",\"color\":\"#000000\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592739441484,\"global_animation\":\"fadeInLeftBig\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592723340518,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592740452409,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"ACTIVITY PROFILE\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"66\",\"xl\":\"66\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 10px 0px\",\"xl\":\"0px 0px 10px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592740452409,\"title_font_family\":\"Anton\",\"global_animation\":\"bounceIn\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592745295709,\"name\":\"divider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_vertical\":0,\"divider_height_vertical\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"divider_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"divider_position\":\"\",\"container_div_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"solid\",\"border_width\":\"1\",\"border_radius\":\"\",\"border_color\":\"#cccccc\",\"margin_top\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"margin_bottom\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592745295709},\"title\":\"Divider\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16 1c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0V1.937c0-.517.42-.937.937-.937zm0 10.547c.518 0 .938.42.938.937v7.032a.937.937 0 11-1.875 0v-7.032c0-.517.42-.937.937-.937zm0 14.062c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0v-3.515c0-.518.42-.938.937-.938z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M21.625 23.3V8.7c0-1.011 1.198-1.518 1.898-.803l7.151 7.3a1.152 1.152 0 010 1.605l-7.151 7.3c-.7.716-1.898.21-1.898-.802z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M10.375 8.7v14.6c0 1.011-1.197 1.518-1.898.803l-7.151-7.3a1.152 1.152 0 010-1.605l7.151-7.3c.7-.716 1.898-.21 1.898.802z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":\"IzhsfzN6oiXNTeR2yH_-T\",\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"custom\",\"sp_tab_item\":[{\"title\":\"Heavy equipment\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-helicopter\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"Ibf79UW01GcQgunRzmc5n\",\"name\":\"row\"}]},{\"title\":\"Light equipment\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-tractor\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"Fih228Ru_G0rwhBWXc7UA\",\"name\":\"row\"}]},{\"title\":\"Specialist gear\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-truck-monster\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"GAsDbBpZfmDDapjBaCaMC\",\"name\":\"row\"}]},{\"title\":\"Special services\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-tools\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"RbqRky3WJBL0WyfJHjKUB\",\"name\":\"row\"}]},{\"title\":\"Our offer\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fab fa-whmcs\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"n9lnYS_wxBx1oKWcSKiuR\",\"name\":\"row\"}]}],\"custom_tab_style\":\"navigation\",\"nav_gutter\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_style\":\"normal\",\"nav_width\":{\"xxl\":\"33\",\"xl\":\"33\",\"lg\":30,\"md\":30,\"sm\":30,\"xs\":30},\"nav_color\":\"#fff\",\"nav_bg_color\":\"#000\",\"nav_fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_border\":\"1px 1px 1px 1px\",\"nav_border_color\":\"#e5e5e5\",\"nav_border_radius\":\"\",\"nav_margin\":{\"xxl\":\"0px 0px 5px 0px\",\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"nav_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"nav_text_align\":\"left\",\"hover_tab_bg\":\"\",\"hover_tab_color\":\"\",\"hover_tab_border_width\":\"\",\"hover_tab_border_color\":\"\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"active_tab_border_width\":\"\",\"active_tab_border_color\":\"\",\"image_or_icon_style\":\"icon_style\",\"nav_icon_postion\":\"left\",\"icon_fontsize\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xxl\":\"   4px\",\"xl\":\"   4px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"nav_image_postion\":\"left\",\"image_height\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_width\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_color\":\"#000\",\"content_backround\":\"\",\"content_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_border\":\"0\",\"content_border_radius\":\"\",\"content_border_color\":\"\",\"show_boxshadow\":1,\"shadow_color\":\"#000\",\"shadow_horizontal\":\"\",\"shadow_vertical\":\"\",\"shadow_blur\":\"\",\"shadow_spread\":\"\",\"content_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"xxl\":\"10px 10px 10px 10px\",\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"10px 0px 30px 0px\",\"xl\":\"10px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"300\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592739030763,\"nav_font_family\":\"Anton\",\"icon_color\":\"#ff9800\",\"global_animation\":\"fadeInRightBig\"},\"title\":\"Tabs\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M30 2.6H2a.4.4 0 00-.4.4v3c0 .22.18.4.4.4h28a.4.4 0 00.4-.4V3a.4.4 0 00-.4-.4zM2 1a2 2 0 00-2 2v3a2 2 0 002 2h28a2 2 0 002-2V3a2 2 0 00-2-2H2z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M7.6 8.6v20.8h17.8V8.6H7.6zM7 7a1 1 0 00-1 1v22a1 1 0 001 1h19a1 1 0 001-1V8a1 1 0 00-1-1H7z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M22 14a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1zM22 19a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1zM17 24a1 1 0 01-1 1h-4a1 1 0 110-2h4a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M11 2a1 1 0 011-1h9a1 1 0 011 1v6H11V2z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744753075,\"name\":\"divider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"image\",\"divider_vertical\":0,\"divider_height_vertical\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"divider_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_repeat\":\"no-repeat\",\"divider_height\":\"1\",\"divider_position\":\"\",\"container_div_width\":{\"xxl\":\"581\",\"xl\":\"581\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"solid\",\"border_width\":\"1\",\"border_radius\":\"\",\"border_color\":\"#cccccc\",\"margin_top\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"margin_bottom\":{\"xxl\":\"14\",\"xl\":\"14\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592744753075},\"title\":\"Divider\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16 1c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0V1.937c0-.517.42-.937.937-.937zm0 10.547c.518 0 .938.42.938.937v7.032a.937.937 0 11-1.875 0v-7.032c0-.517.42-.937.937-.937zm0 14.062c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0v-3.515c0-.518.42-.938.937-.938z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M21.625 23.3V8.7c0-1.011 1.198-1.518 1.898-.803l7.151 7.3a1.152 1.152 0 010 1.605l-7.151 7.3c-.7.716-1.898.21-1.898-.802z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M10.375 8.7v14.6c0 1.011-1.197 1.518-1.898.803l-7.151-7.3a1.152 1.152 0 010-1.605l7.151-7.3c.7-.716 1.898-.21 1.898.802z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592744680206,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"4px 0px 0px 0px\",\"xl\":\"4px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"50px  50px \",\"xs\":\"50px  50px \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"custom\",\"background_attachment\":\"scroll\",\"background_position\":\"100% 0\",\"background_video\":0,\"external_background_video\":\"0\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#ffffff\",\"bottom_shape_width\":{\"xxl\":\"247\",\"xl\":\"247\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"80\",\"xl\":\"80\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592744680206,\"row_border\":0,\"background_type\":\"image\",\"background_color\":\"#000000\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"overlay_type\":\"overlay_color\",\"background_size_custom\":{\"xxl\":\"226\",\"xl\":\"226\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border_radius\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"gradient_overlay\":{\"color\":\"#000000\",\"color2\":\"#4527d0\"},\"background_position_custom_x\":{\"xxl\":\"1500\",\"xl\":\"1500\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_position_custom_y\":{\"xxl\":\"120\",\"xl\":\"120\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1592744678934,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1592744678935,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1592744678938,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1586875655111,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"32px 0px 62px 0px\",\"xl\":\"32px 0px 62px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0   \",\"xl\":\"0   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#ff7d00\",\"color2\":\"#ffffff\",\"deg\":\"180\",\"type\":\"linear\",\"pos2\":\"20\",\"pos\":\"0\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.8)\",\"color2\":\"rgba(209, 209, 209, 0.27)\",\"deg\":\"0\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"slope\",\"shape_color\":\"rgba(255, 255, 255, 0.68)\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586875655111,\"background_color\":\"#e4e4e4\",\"row_border_width\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1586875655110,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1586875693189,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"instFormId\":1586875693189,\"id\":\"101\",\"global_margin_sm\":\"0px 0px 10px 0px\",\"global_margin_xs\":\"0px 0px 10px 0px\",\"global_margin_xl\":\"0px 0px 30px 0px\",\"global_margin_lg\":\"0px 0px 20px 0px\",\"global_margin_md\":\"0px 0px 20px 0px\",\"global_margin_xxl\":\"0px 0px 30px 0px\"},\"title\":\"Joomla Module\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.005 1C6.821.994 8.391 2.176 8.849 3.923c.065.25.136.315.407.218 1.234-.443 2.449-.289 3.638.212.917.386 1.712.97 2.461 1.62.117.102.13.16.013.275-.846.803-1.686 1.613-2.52 2.429-.135.135-.22.096-.348 0-.375-.27-.789-.482-1.267-.514-1.124-.077-2.255.79-2.565 1.972-.265 1.015.097 1.87.724 2.64.51.623 1.13 1.144 1.7 1.709a402.759 402.759 0 004.115 4.015c.245.238.22.353-.013.572-.808.77-1.596 1.554-2.384 2.344-.155.16-.246.2-.427.013-2.358-2.364-4.742-4.709-7.094-7.085-1.189-1.208-2.01-3.335-.943-5.236.168-.308-.11-.25-.24-.283-1-.244-1.815-.77-2.383-1.625-.885-1.336-.956-2.724-.22-4.13.66-1.285 2.01-2.063 3.502-2.069z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M28.129 10.732c0 1.337-.524 2.493-1.28 3.553-.239.327-.51.63-.762.95-.116.148-.194.135-.323 0a207.68 207.68 0 00-2.352-2.415c-.155-.154-.168-.263-.039-.456.485-.707.672-1.471.24-2.261-.479-.887-1.222-1.465-2.262-1.548-1.085-.084-1.919.462-2.636 1.194-1.693 1.748-3.36 3.514-5.046 5.262-.31.32-.226.347-.581.006-.834-.803-1.66-1.612-2.5-2.409-.156-.148-.175-.238-.007-.398 2.351-2.326 4.677-4.69 7.055-6.99 1.286-1.24 3.36-1.895 5.188-.905.226.122.252.025.304-.167.413-1.632 1.44-2.666 3.095-3.039 2.203-.494 4.432 1.067 4.736 3.283.284 2.081-.912 3.88-2.966 4.445-.226.058-.24.129-.168.328.097.25.155.507.22.764.077.27.09.534.084.803zM11.13 27.936a3.725 3.725 0 01-1.861-.43c-.252-.136-.297-.046-.349.173a3.93 3.93 0 01-3.67 2.98c-1.906.052-3.514-1.04-4.044-2.755-.627-2.03.626-4.195 2.778-4.754.29-.077.317-.148.213-.418-.484-1.297-.245-2.537.394-3.726.375-.694.847-1.31 1.376-1.888.143-.154.233-.16.388-.013.788.79 1.583 1.567 2.371 2.351.09.09.149.154.052.296-.924 1.432-.53 2.723 1.04 3.43 1.163.52 2.203.186 3.108-.572.788-.662 1.499-1.407 2.235-2.12 1.183-1.15 2.365-2.3 3.54-3.456.169-.167.272-.199.46-.013.82.842 1.66 1.67 2.5 2.5.142.14.162.23 0 .378-2.41 2.236-4.8 4.49-7.23 6.713a4.933 4.933 0 01-3.301 1.324z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M27.01 31a3.803 3.803 0 01-3.682-2.884c-.084-.322-.18-.328-.465-.238-1.39.417-2.694.103-3.935-.559-.691-.373-1.305-.86-1.893-1.381-.148-.135-.18-.219-.02-.373.789-.77 1.57-1.548 2.346-2.338.162-.167.252-.135.414-.013.62.475 1.292.765 2.093.501.86-.282 1.667-1.387 1.712-2.3.045-1.021-.4-1.843-1.085-2.543-1.622-1.664-3.263-3.315-4.891-4.966-.22-.219-.575-.437-.595-.681-.02-.25.381-.443.601-.655.64-.63 1.292-1.253 1.932-1.89.149-.153.233-.14.375.007 2.274 2.326 4.574 4.638 6.829 6.977 1.221 1.265 1.893 3.417.93 5.203-.122.225-.013.264.168.308 1.628.424 2.598 1.478 2.946 3.09.524 2.429-1.35 4.754-3.78 4.735z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1586928186976,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"instFormId\":1586928186976,\"id\":\"100\",\"global_margin_sm\":\"0px 0px 10px 0px\",\"global_margin_xs\":\"0px 0px 10px 0px\",\"global_margin_xl\":\"0px 0px 30px 0px\",\"global_margin_lg\":\"0px 0px 20px 0px\",\"global_margin_md\":\"0px 0px 20px 0px\",\"global_margin_xxl\":\"0px 0px 30px 0px\"},\"title\":\"Joomla Module\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.005 1C6.821.994 8.391 2.176 8.849 3.923c.065.25.136.315.407.218 1.234-.443 2.449-.289 3.638.212.917.386 1.712.97 2.461 1.62.117.102.13.16.013.275-.846.803-1.686 1.613-2.52 2.429-.135.135-.22.096-.348 0-.375-.27-.789-.482-1.267-.514-1.124-.077-2.255.79-2.565 1.972-.265 1.015.097 1.87.724 2.64.51.623 1.13 1.144 1.7 1.709a402.759 402.759 0 004.115 4.015c.245.238.22.353-.013.572-.808.77-1.596 1.554-2.384 2.344-.155.16-.246.2-.427.013-2.358-2.364-4.742-4.709-7.094-7.085-1.189-1.208-2.01-3.335-.943-5.236.168-.308-.11-.25-.24-.283-1-.244-1.815-.77-2.383-1.625-.885-1.336-.956-2.724-.22-4.13.66-1.285 2.01-2.063 3.502-2.069z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M28.129 10.732c0 1.337-.524 2.493-1.28 3.553-.239.327-.51.63-.762.95-.116.148-.194.135-.323 0a207.68 207.68 0 00-2.352-2.415c-.155-.154-.168-.263-.039-.456.485-.707.672-1.471.24-2.261-.479-.887-1.222-1.465-2.262-1.548-1.085-.084-1.919.462-2.636 1.194-1.693 1.748-3.36 3.514-5.046 5.262-.31.32-.226.347-.581.006-.834-.803-1.66-1.612-2.5-2.409-.156-.148-.175-.238-.007-.398 2.351-2.326 4.677-4.69 7.055-6.99 1.286-1.24 3.36-1.895 5.188-.905.226.122.252.025.304-.167.413-1.632 1.44-2.666 3.095-3.039 2.203-.494 4.432 1.067 4.736 3.283.284 2.081-.912 3.88-2.966 4.445-.226.058-.24.129-.168.328.097.25.155.507.22.764.077.27.09.534.084.803zM11.13 27.936a3.725 3.725 0 01-1.861-.43c-.252-.136-.297-.046-.349.173a3.93 3.93 0 01-3.67 2.98c-1.906.052-3.514-1.04-4.044-2.755-.627-2.03.626-4.195 2.778-4.754.29-.077.317-.148.213-.418-.484-1.297-.245-2.537.394-3.726.375-.694.847-1.31 1.376-1.888.143-.154.233-.16.388-.013.788.79 1.583 1.567 2.371 2.351.09.09.149.154.052.296-.924 1.432-.53 2.723 1.04 3.43 1.163.52 2.203.186 3.108-.572.788-.662 1.499-1.407 2.235-2.12 1.183-1.15 2.365-2.3 3.54-3.456.169-.167.272-.199.46-.013.82.842 1.66 1.67 2.5 2.5.142.14.162.23 0 .378-2.41 2.236-4.8 4.49-7.23 6.713a4.933 4.933 0 01-3.301 1.324z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M27.01 31a3.803 3.803 0 01-3.682-2.884c-.084-.322-.18-.328-.465-.238-1.39.417-2.694.103-3.935-.559-.691-.373-1.305-.86-1.893-1.381-.148-.135-.18-.219-.02-.373.789-.77 1.57-1.548 2.346-2.338.162-.167.252-.135.414-.013.62.475 1.292.765 2.093.501.86-.282 1.667-1.387 1.712-2.3.045-1.021-.4-1.843-1.085-2.543-1.622-1.664-3.263-3.315-4.891-4.966-.22-.219-.575-.437-.595-.681-.02-.25.381-.443.601-.655.64-.63 1.292-1.253 1.932-1.89.149-.153.233-.14.375.007 2.274 2.326 4.574 4.638 6.829 6.977 1.221 1.265 1.893 3.417.93 5.203-.122.225-.013.264.168.308 1.628.424 2.598 1.478 2.946 3.09.524 2.429-1.35 4.754-3.78 4.735z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1586877522719,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"22px 0px 50px 0px\",\"xl\":\"22px 0px 50px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#ffffff\",\"color2\":\"#dbdbdb\",\"deg\":\"360\",\"type\":\"linear\",\"pos\":\"18\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":1,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"xxl\":\"155\",\"xl\":\"155\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_position_custom_y\":{\"xxl\":\"456\",\"xl\":\"456\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"external_background_video\":0,\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"media\\/videos\\/2020\\/04\\/06\\/welcome---24829.mp4\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.8)\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"15\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"darken\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":1,\"shape_name\":\"slope\",\"shape_color\":\"#ff8400\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"25\",\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":1,\"shape_to_front\":0,\"show_bottom_shape\":1,\"bottom_shape_name\":\"hill-wave\",\"bottom_shape_color\":\"#ff8400\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586877522719,\"background_color\":\"#ffffff\",\"row_border_width\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"overlay\":\"\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1586877522718,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1586878849857,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Contact our office\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#ff0101\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586878849857,\"global_text_color\":\"#bcbcbc\",\"title_font_family\":\"Play\"},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592804498527,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/06\\/22\\/woman-851446_1280.jpg\",\"height\":959,\"width\":1280},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592804498527,\"global_animation\":\"bounceIn\"},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1586877522728,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1586878146938,\"name\":\"ajax_contact\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"recipient_email\":\"email@yourdomain.com\",\"from_name\":\"\",\"from_email\":\"\",\"show_phone\":0,\"field_bg_color\":\"\",\"field_color\":\"\",\"field_placeholder_color\":\"\",\"input_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_font_size\":\"\",\"field_border_width\":\"   \",\"field_border_color\":\"\",\"field_border_radius\":\"\",\"field_margin\":{\"xxl\":\"0px 0px 20px 0px\",\"xl\":\"0px 0px 20px 0px\",\"lg\":\"0px 0px 15px 0px\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 15px 0px\"},\"field_padding\":\"   \",\"textarea_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_hover_bg_color\":\"\",\"field_hover_placeholder_color\":\"\",\"field_focus_border_color\":\"\",\"formcaptcha\":1,\"captcha_type\":\"default\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_input_col\":\"12\",\"captcha_answer\":\"7\",\"name_input_col\":\"12\",\"email_input_col\":\"12\",\"subject_input_col\":\"12\",\"phone_input_col\":\"12\",\"message_input_col\":\"12\",\"show_label\":0,\"show_checkbox\":1,\"checkbox_title\":\"I agree with the <a href=\\\"#\\\">Terms of Use<\\/a> and <a href=\\\"#\\\">Privacy Policy<\\/a> and I declare that I have read the information that is required in accordance with <a href=\\\"http:\\/\\/eur-lex.europa.eu\\/legal-content\\/EN\\/TXT\\/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.<\\/a>\",\"use_custom_button\":1,\"button_text\":\"Send Message\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"#b8b4b4\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#848484\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"button_icon_margin\":\"   \",\"button_position\":\"sppb-text-right\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"70px 0px 30px 0px\",\"xl\":\"70px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586878146938,\"button_shape\":\"square\",\"button_icon_position\":\"left\",\"button_icon\":\"fab fa-telegram-plane\",\"global_text_color\":\"#dbdbdb\",\"global_link_color\":\"#ffc687\",\"global_animation\":\"zoomIn\"},\"title\":\"Contact Form\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M10 30V2h3a1 1 0 100-2H5a1 1 0 100 2h3v28H5a1 1 0 100 2h8a1 1 0 100-2h-3z\\\" fill=\\\"currentColor\\\"\\/><g opacity=\\\".5\\\" fill=\\\"currentColor\\\"><path d=\\\"M5 4a1 1 0 110 2H2v20h3a1 1 0 110 2H2a2 2 0 01-2-2V6a2 2 0 012-2h3zM30 4a2 2 0 012 2v20a2 2 0 01-2 2H13a1 1 0 110-2h17V6H13a1 1 0 110-2h17z\\\"\\/><\\/g><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1579327022890,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"0px 0px 2px 0px\",\"xl\":\"0px 0px 2px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1579327022890,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1579327022889,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1579328695019,\"name\":\"openstreetmap\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"height\":{\"xxl\":\"389\",\"xl\":\"389\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"map_style\":\"CartoDB.Positron\",\"multi_location_items\":[{\"title\":\"Location Item Title\",\"location_item\":\"50.09711, 20.05282\",\"location_popup_text\":\"Os na stoku Krakow Poland\",\"custom_icon\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}}],\"zoom\":\"16\",\"mousescroll\":0,\"dragging\":1,\"zoomcontrol\":1,\"attribution\":1,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px  0px\",\"xl\":\"0px 0px  0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1579328695019},\"title\":\"Open Street Map\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M12.3 12.125c-.232-2.793.475-5.33 2.202-7.567.327-.43.691-.823 1.077-1.195.503-.485 1.042-.935 1.582-1.387l.087-.072c-.297-.172-.61-.285-.919-.397-.378-.137-.749-.271-1.074-.507h-.348c-.756.3-1.546.493-2.336.686-.432.105-.864.21-1.29.334-.98.28-1.97.53-2.96.78-.404.102-.809.205-1.213.31l-.024.005c-.175.044-.332.084-.532.017a649.995 649.995 0 00-4.106-1.341l-.089-.029-2.097-.68c-.026 0-.039-.026-.053-.052A.339.339 0 00.19 1H.074l.021.063.087.258.008.027.07.208.07.213.538 1.613c.422 1.262.847 2.525 1.28 3.783.128.36.14.684.012 1.054-.313.91-.617 1.82-.921 2.73-.304.91-.608 1.819-.921 2.729-.116.37-.116.695 0 1.066.231.73.457 1.46.684 2.193.363 1.174.726 2.349 1.112 3.52.127.405.116.764 0 1.17a776.683 776.683 0 00-2.005 6.918c-.011.035-.027.07-.044.105-.048.106-.098.214-.037.335.209.44 1.298.719 1.68.406a8.165 8.165 0 00.319-.278c.233-.213.455-.436.678-.66l.139-.14c1.17-1.176 2.344-2.349 3.517-3.522 1.173-1.174 2.347-2.347 3.517-3.523.417-.417.88-.73 1.483-.556.533.15.939-.012 1.321-.337.117-.095.23-.195.344-.295.203-.18.407-.36.63-.516.278-.197.278-.37.127-.66-.355-.693-.704-1.395-1.053-2.099-.3-.603-.6-1.207-.905-1.806-.174-.348-.29-.73.023-1.009.569-.512.515-1.132.459-1.787a18.783 18.783 0 01-.007-.078zm-1.963.549a5.334 5.334 0 00-.01-.138l-.012-.153-.008-.09v-.003c-.258-3.108.487-6.005 2.316-8.558-.268.067-.525.133-.788.21h-.005c-1.01.29-2.048.552-3.049.805-.398.1-.79.2-1.172.298l-.008.002-.007.002-.03.008c-.174.048-.857.234-1.643-.027-.896-.297-1.79-.59-2.686-.88.265.787.532 1.572.802 2.356.264.75.299 1.538.015 2.364-.31.9-.612 1.802-.916 2.713l-.002.004c-.29.87-.584 1.748-.886 2.627.232.734.454 1.452.674 2.162.358 1.157.71 2.296 1.092 3.455l.004.013.004.013c.261.832.222 1.595.015 2.32l-.003.009-.003.01c-.292.987-.581 1.976-.868 2.965l1.782-1.783.002-.002a2033.18 2033.18 0 003.513-3.519l.004-.003c.465-.466 1.498-1.366 2.968-1.167l-.51-1.025c-.305-.614-.605-1.218-.88-1.756l-.003-.007-.003-.006c-.116-.231-.339-.707-.378-1.292a2.555 2.555 0 01.679-1.927zM30.494 23.273v-.002l-.158-1.294c-.067-.548-.134-1.1-.205-1.662l-.002-.02-.064-.51-.06.026a.914.914 0 00-.172.09c-.536.384-1.083.723-1.643 1.012-2.067 1.069-4.3 1.468-6.735 1.085a.859.859 0 00-.823.324c-.394.487-.834.464-1.333.209-.564-.286-1.128-.561-1.692-.837l-.845-.415-.029-.014c-1.432-.704-1.439-.707-2.475.536l-.046.055c-.287.34-.572.678-.44 1.173.197.742-.14 1.252-.626 1.738A2414.87 2414.87 0 007.9 29.97l-.607.606-.008.007v.001l-.095.095-.29.29c-.037.036-.084.071-.133.108-.137.102-.28.21-.203.355.085.17.237.118.394.065.078-.027.158-.054.232-.054a.342.342 0 00.156-.028l.057-.023c.036-.015.073-.03.111-.041l1.006-.287 1.362-.386.198-.056c1.34-.38 2.68-.76 4.016-1.149a1.838 1.838 0 011.17.035c1.088.394 2.18.784 3.272 1.174.806.287 1.612.575 2.418.866.302.115.58.127.881.011l1.602-.618c1.274-.493 2.55-.986 3.833-1.468.313-.116.51-.301.649-.602.483-1.03.971-2.055 1.458-3.078.33-.694.66-1.386.987-2.08l.025-.049c.063-.12.123-.238.103-.39zM13.024 27.7l.513-.15.01-.002a3.836 3.836 0 012.385.072l.008.003.007.002c1.088.394 2.169.78 3.256 1.168.73.26 1.462.522 2.2.788l1.306-.504c1.173-.454 2.357-.911 3.543-1.359.439-.931.883-1.866 1.325-2.795l.878-1.848-.008-.066a12.588 12.588 0 01-6.726 1.042 2.802 2.802 0 01-1.508.642c-.773.08-1.417-.174-1.82-.38-.551-.28-1.091-.543-1.646-.814-.285-.14-.573-.28-.87-.427l-.027-.013-.027-.013-.015.018a3.38 3.38 0 01-.254 1.716c-.27.63-.688 1.094-.994 1.4l-.008.008-1.528 1.512z\\\" fill=\\\"currentColor\\\"\\/><circle opacity=\\\".5\\\" cx=\\\"24.5\\\" cy=\\\"10.5\\\" r=\\\"7.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1586959917835,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"24px 0px 2px 0px\",\"xl\":\"24px 0px 2px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/04\\/08\\/church.png\",\"height\":100,\"width\":100},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.03)\",\"color2\":\"rgba(140, 140, 140, 0.24)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586959917835,\"background_color\":\"#b4b4b4\",\"id\":\"\",\"row_border\":0,\"container_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"container_max_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1586959917885,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1586961580791,\"name\":\"clients\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"create_carousel\":1,\"carousel_margin\":20,\"carousel_autoplay\":1,\"carousel_speed\":2000,\"carousel_interval\":3500,\"carousel_arrow\":0,\"carousel_bullet\":0,\"count\":\"sppb-col-sm-3\",\"alignment\":\"sppb-text-center\",\"sp_clients_item\":[{\"title\":\"Diablodesign\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/logo_bl.png\",\"height\":99,\"width\":288},\"url_same_window\":0,\"url\":\"https:\\/\\/diablodesign.eu\\/\"},{\"title\":\"Templatki\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/templatkicom.png\",\"height\":56,\"width\":300},\"url_same_window\":0,\"url\":\"https:\\/\\/templatki.com\"},{\"title\":\"Biurorachunkowe.be\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/biurorachunkowe.png\",\"height\":134,\"width\":421},\"url_same_window\":0,\"url\":\"https:\\/\\/biurorachunkowe.be\\/\"},{\"title\":\"LOT\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/polishairlines.png\",\"height\":600,\"width\":1000},\"url_same_window\":0},{\"title\":\"ORLEN\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/orlenlogo.png\",\"height\":148,\"width\":341},\"url_same_window\":0}],\"add_css_filder\":[\"grayscale\",\"opacity\"],\"grayscale_value\":\"100\",\"opacity_value\":\"77\",\"remove_filter\":1,\"scale_on_hover\":1,\"scale_value\":\"1.3\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586961580791,\"carousel_item_number\":{\"xxl\":\"8\",\"xl\":\"8\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_link_color\":\"#4e4e4e\"},\"title\":\"Clients\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M26.7 16.7h-2.3c.2.6.4 1.3.4 2.1v8.8c0 .3-.1.6-.1.9h3.8c1.4 0 2.6-1.2 2.6-2.6v-4.8c-.1-2.4-2-4.4-4.4-4.4zM7.3 18.8c0-.7.1-1.4.4-2.1H5.3C2.9 16.7 1 18.6 1 21v4.8c0 1.4 1.2 2.6 2.6 2.6h3.8c-.1-.3-.1-.6-.1-.9v-8.7z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M23 28.4H9v-9.6c0-2.4 1.9-4.3 4.3-4.3h5.3c2.4 0 4.3 1.9 4.3 4.3v9.6h.1zm-12-2h10v-7.6c0-1.3-1-2.3-2.3-2.3h-5.3c-1.3 0-2.3 1-2.3 2.3v7.6H11zM16 13.4c-.9 0-1.8-.2-2.5-.7-1.6-.9-2.7-2.7-2.7-4.5C10.8 5.3 13.1 3 16 3c2.9 0 5.2 2.3 5.2 5.2 0 1.9-1 3.6-2.7 4.5-.7.5-1.6.7-2.5.7zM16 5c-1.8 0-3.2 1.4-3.2 3.2 0 1.2.6 2.2 1.6 2.8 1 .5 2.2.5 3.1 0 1-.6 1.6-1.6 1.6-2.8C19.2 6.4 17.8 5 16 5z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M6.9 7.9C4.7 7.9 3 9.6 3 11.7c0 2.1 1.7 3.9 3.9 3.9.5 0 1.1-.1 1.5-.3.8-.4 1.5-1 1.9-1.7.3-.5.5-1.2.5-1.8-.1-2.2-1.8-3.9-3.9-3.9zM25.1 7.9c-2.1 0-3.9 1.7-3.9 3.9 0 .7.2 1.3.5 1.8.4.8 1.1 1.4 1.9 1.7.5.2 1 .3 1.5.3 2.1 0 3.9-1.7 3.9-3.9 0-2.1-1.7-3.8-3.9-3.8z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592723338928,\"settings\":{\"padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"4,4,4\",\"visibility\":true,\"columns\":[{\"id\":1592723338929,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 0px 0px\",\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"}},\"addons\":[{\"id\":1592723338930,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\" Gravel truck 30 tons\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"25\",\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$1200\",\"price_color\":\"\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"\",\"pricing_content_font_size\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":\"55\",\"xl\":\"55\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Buy Now\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_background_color\":\"#ffffff\",\"button_color\":\"#fff\",\"button_background_color_hover\":\"#ff5e00\",\"button_color_hover\":\"#fff\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"45px 45px 50px 45px\",\"xl\":\"45px 45px 50px 45px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_border_color\":\"#F2F2F2\",\"global_boder_style\":\"solid\",\"global_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"62\",\"xl\":\"62\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_overlay\":1,\"title_font_style\":{\"weight\":600},\"global_background_image\":{\"src\":\"images\\/2020\\/06\\/21\\/loader-1846346_640.jpg\",\"height\":428,\"width\":640},\"global_background_size\":\"cover\",\"global_background_repeat\":\"no-repeat\",\"instFormId\":1592723338930,\"button_status\":\"hover\",\"global_background_type\":\"image\",\"title_font_family\":\"Arial\",\"global_overlay_type\":\"overlay_color\",\"global_background_overlay\":\"rgba(0, 0, 0, 0.37)\",\"button_url\":\"https:\\/\\/diablodesign.eu\",\"button_target\":\"_blank\",\"global_pattern_overlay\":{\"src\":\"images\\/2020\\/06\\/21\\/86.jpg\",\"height\":619,\"width\":1980},\"pricing_hover_scale\":\"1\",\"pricing_hover_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"8\",\"spread\":0,\"color\":\"#ffb500\",\"inset\":false}},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592723338931,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1592723338932,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Big rock truck 30 tons\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"24\",\"xl\":\"24\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$1169\",\"price_color\":\"\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"\",\"pricing_content_font_size\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":\"55\",\"xl\":\"55\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Buy Now\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_background_color\":\"#ffffff\",\"button_color\":\"#fff\",\"button_background_color_hover\":\"#ff5e00\",\"button_color_hover\":\"#fff\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"45px 45px 50px 45px\",\"xl\":\"45px 45px 50px 45px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_border_color\":\"#F2F2F2\",\"global_boder_style\":\"solid\",\"global_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"62\",\"xl\":\"62\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_overlay\":1,\"title_font_style\":{\"weight\":600},\"global_background_image\":{\"src\":\"images\\/2020\\/06\\/21\\/digger-1453430_640.jpg\",\"height\":376,\"width\":640},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"instFormId\":1592723338932,\"global_background_type\":\"image\",\"button_status\":\"hover\",\"global_overlay_type\":\"overlay_color\",\"title_font_family\":\"Arial\",\"global_background_overlay\":\"rgba(0, 0, 0, 0.37)\",\"pricing_hover_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"8\",\"spread\":0,\"color\":\"#ffb500\",\"inset\":false},\"pricing_hover_scale\":\"1\"},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592723338933,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":[],\"addons\":[{\"id\":1592723338934,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Demolition of buildings 1 hour\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$2000\",\"price_color\":\"\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"\",\"pricing_content_font_size\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":\"55\",\"xl\":\"55\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Buy Now\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_background_color\":\"#ffffff\",\"button_color\":\"#fff\",\"button_background_color_hover\":\"#ff5e00\",\"button_color_hover\":\"#fff\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"45px 45px 50px 45px\",\"xl\":\"45px 45px 50px 45px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_border_color\":\"#F2F2F2\",\"global_boder_style\":\"solid\",\"global_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"62\",\"xl\":\"62\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_overlay\":1,\"title_font_style\":{\"weight\":600},\"global_background_image\":{\"src\":\"images\\/2020\\/06\\/21\\/crash-1651305_640.jpg\",\"height\":480,\"width\":640},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"instFormId\":1592723338934,\"button_status\":\"hover\",\"global_background_type\":\"image\",\"global_overlay_type\":\"overlay_color\",\"title_font_family\":\"Arial\",\"global_background_overlay\":\"rgba(0, 0, 0, 0.37)\",\"pricing_hover_scale\":\"1\",\"pricing_hover_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"8\",\"spread\":0,\"color\":\"#ffb500\",\"inset\":false}},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592723338889,\"columnId\":1592723338925}},{\"id\":\"Ibf79UW01GcQgunRzmc5n\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"dM7ehG80U26uLFWj93plz\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592723337,\"name\":\"text_block\",\"settings\":{\"text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.<\\/div>\",\"dropcap\":0,\"text_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_user_border\":0,\"global_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592723340519,\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"Fih228Ru_G0rwhBWXc7UA\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"RFhUX0t2mcsDPc5J4w0gA\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592739045310,\"name\":\"text_block\",\"settings\":{\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt.\\n<div style=\\\"text-align: justify;\\\">\\u00a0<\\/div>\",\"dropcap\":0,\"text_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"Ibf79UW01GcQgunRzmc5n\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"GAsDbBpZfmDDapjBaCaMC\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"MS8oCnqsd2_ojVUXyY-w4\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592739045815,\"name\":\"text_block\",\"settings\":{\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt.\\n<div style=\\\"text-align: justify;\\\">\\u00a0<\\/div>\",\"dropcap\":0},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"Fih228Ru_G0rwhBWXc7UA\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"RbqRky3WJBL0WyfJHjKUB\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"UXdRcQEgDqYiBtkGbQ1vT\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592739046337,\"name\":\"text_block\",\"settings\":{\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt.\",\"dropcap\":0},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"GAsDbBpZfmDDapjBaCaMC\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"n9lnYS_wxBx1oKWcSKiuR\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"jn9j5tx2YMtBrSSZlBCZO\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1592739047166,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"dropcap\":0},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"RbqRky3WJBL0WyfJHjKUB\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":1592744678935,\"settings\":{\"padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1592744678936,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":[],\"addons\":[{\"id\":1592744678937,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Our machines in use\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"50\",\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"title_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"<div class=\\\"tlid-input input\\\">\\u00a0<\\/div>\\n<div class=\\\"tlid-results-container results-container\\\">\\n<div class=\\\"tlid-result result-dict-wrapper\\\">\\n<div class=\\\"result tlid-copy-target\\\">\\n<div class=\\\"text-wrap tlid-copy-target\\\">\\n<div class=\\\"result-shield-container tlid-copy-target\\\" tabindex=\\\"0\\\"><span class=\\\"tlid-translation translation\\\" lang=\\\"en\\\"><span class=\\\"\\\" title=\\\"\\\">Our machines rented to an external company<\\/span><\\/span><\\/div>\\n<\\/div>\\n<\\/div>\\n<\\/div>\\n<\\/div>\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"xxl\":\"14\",\"xl\":\"14\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dropcap\":0,\"class\":\"\",\"title_font_style\":{\"weight\":400},\"title_margin_top\":{\"xxl\":\"20\",\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"25\",\"xs\":\"25\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"xxl\":\" auto 45px auto\",\"xl\":\" auto 45px auto\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":1,\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"58\",\"xl\":\"58\",\"lg\":\"90\",\"md\":\"90\",\"sm\":\"100\",\"xs\":\"100\"},\"instFormId\":1592744678937,\"text_font_family\":\"Anton\",\"title_text_color\":\"#ff7200\",\"font_family\":\"Anton\",\"global_text_color\":\"#ffffff\",\"global_animation\":\"fadeInUp\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592744680206,\"columnId\":1592744678934}},{\"id\":1592744678938,\"settings\":{\"padding\":{\"xxl\":\"86px 0px 84px 0px\",\"xl\":\"86px 0px 84px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1592744678939,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":[],\"addons\":[{\"id\":1592744678940,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"66\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\"Excavators\",\"show_percentage\":1,\"class\":\"\",\"instFormId\":1592744678940,\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\"},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744678941,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"38\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\" Bulldozers\",\"show_percentage\":1,\"class\":\"\",\"instFormId\":1592744678941,\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\"},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744678942,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"97\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\"Cranes\",\"show_percentage\":1,\"class\":\"\",\"instFormId\":1592744678942,\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\"},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744678943,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"73\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\"Trucks\",\"show_percentage\":1,\"class\":\"\",\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\",\"instFormId\":1592744678943},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592744678944,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":[],\"addons\":[{\"id\":1592744678945,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"<p class=\\\"p1\\\" style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.<\\/p>\",\"alignment\":\"\",\"text_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"xxl\":\"25\",\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dropcap\":0,\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"xxl\":\"   \",\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":1,\"global_text_color\":\"rgba(255, 255, 255, 0.7)\",\"instFormId\":1592744678945,\"text_font_family\":\"Anton\",\"global_animation\":\"fadeInRight\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592744680206,\"columnId\":1592744678934}}]', '[{\"id\":1586168484247,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"show_top_shape\":1,\"shape_name\":\"turning-slope\",\"shape_color\":\"#000000\",\"shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"5\",\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":1,\"show_bottom_shape\":1,\"bottom_shape_name\":\"turning-slope\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"163\",\"xl\":\"163\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586168484247,\"slider_settings\":\"slider_global\",\"controllers\":\"dot\",\"row_border\":0,\"columns_content_alignment\":\"center\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1586168484299,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586168484299,\"slider_settings\":\"slider_global\",\"padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"column_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1586168484300,\"name\":\"js_slideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"slider_settings\":\"slider_global\",\"height\":\"custom\",\"custom_height\":{\"xxl\":\"600\",\"xl\":\"600\",\"lg\":600,\"md\":600,\"sm\":\"550\",\"xs\":\"550\"},\"slider_animation\":\"fade\",\"slide_vertically\":1,\"three_d_rotate\":15,\"autoplay\":1,\"interval\":5,\"speed\":800,\"timer\":0,\"timer_position\":\"bottom\",\"timer_bg_color\":\"rgba(0, 0, 0, 0)\",\"class\":\"\",\"controllers\":\"dot\",\"dot_controllers\":1,\"dot_controllers_style\":\"line\",\"line_indecator\":1,\"dot_controllers_position\":\"vertical_right\",\"dot_controllers_bottom_gap\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controllers_left_gap\":{\"xxl\":\"791\",\"xl\":\"791\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controllers_right_gap\":{\"xxl\":\"2068\",\"xl\":\"2068\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dot_controller_style_option\":\"dot_active\",\"dot_ctlr_height\":\"3\",\"dot_ctlr_width\":\"\",\"dot_ctlr_bg\":\"\",\"dot_ctlr_border_width\":\"\",\"dot_ctlr_border_color\":\"\",\"dot_ctlr_border_radius\":\"0\",\"dot_ctlr_margin\":\"\",\"dot_ctlr_center_bg\":\"#ffffff\",\"dot_ctlr_hover_height\":\"1\",\"dot_ctlr_hover_width\":\"48\",\"dot_ctlr_hover_border_color\":\"\",\"arrow_controllers\":0,\"arrow_on_hover\":0,\"arrow_controllers_style\":\"spread\",\"arrow_controllers_content\":\"icon_only\",\"arrow_controllers_position\":\"bottom_center\",\"arrow_controllers_bottom_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_controllers_left_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_spread_controllers_left_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_spread_controllers_right_gap\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_style\":\"arrow_normal\",\"arrow_ctlr_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_color\":\"\",\"arrow_ctlr_font_size\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_background\":\"\",\"arrow_ctlr_border_width\":\"\",\"arrow_ctlr_border_color\":\"\",\"arrow_ctlr_border_radius\":\"\",\"arrow_ctlr_hover_background\":\"\",\"arrow_ctlr_hover_color\":\"\",\"arrow_ctlr_hover_border_color\":\"\",\"content_container_width\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"85\",\"md\":\"85\",\"sm\":\"95\",\"xs\":\"95\"},\"content_vertical_alignment\":1,\"slideshow_items\":[{\"title\":\"slide 1\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/16\\/sl1.jpg\",\"height\":835,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR \",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overlay\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 125, 0, 0.75)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\",\"type\":\"linear\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}},{\"title\":\"slide 2\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/17\\/sl3.jpg\",\"height\":835,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR \",\"content_tabs\":\"content_type\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overlay\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 141, 0, 0.86)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\",\"type\":\"linear\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}},{\"title\":\"slide 3\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/16\\/sl2.jpg\",\"height\":795,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR\",\"content_tabs\":\"content_animation\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"left\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overlay\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 141, 0, 0.86)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\",\"type\":\"linear\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}},{\"title\":\"slide 4\",\"slider_img\":{\"src\":\"images\\/2020\\/06\\/17\\/sl4.jpg\",\"height\":835,\"width\":1980},\"slideshow_inner_items\":[{\"title\":\"Hello, I\\u2019m\",\"content_tabs\":\"content_style\",\"content_type\":\"title_content\",\"title_content_title\":\"Hello, I\\u2019m\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20\",\"xs\":\"20\"},\"content_lineheight\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"},{\"title\":\"EXCAVATOR\",\"content_tabs\":\"content_animation\",\"content_type\":\"title_content\",\"title_content_title\":\"EXCAVATOR \",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, ne eam iusto sapientem persecuti, id noster volumus nec.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"zoom\",\"animation_slide_direction\":\"right\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"content_lineheight\":{\"xxl\":\"68\",\"xl\":\"68\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\",\"content_text_shadow\":{\"ho\":\"\",\"vo\":\"2\",\"blur\":0,\"spread\":0,\"color\":\"#000000\",\"inset\":false}},{\"title\":\"Text\",\"content_tabs\":\"content_type\",\"content_type\":\"text_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Button Text\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"content_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"\",\"content_border_color\":\"\",\"content_border_radius\":\"\",\"content_margin\":{\"xxl\":\"25px 0px 0px 0px\",\"xl\":\"25px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#fff\",\"content_font_style\":{\"uppercase\":false,\"weight\":400},\"content_font_family\":\"Oxygen\",\"content_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#e0e0e0\",\"inset\":false}},{\"title\":\"Button\",\"content_tabs\":\"content_style\",\"content_type\":\"btn_content\",\"title_content_title\":\"Corabelle Durrad\",\"title_heading_selector\":\"h2\",\"content_text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do <br \\/>eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut<br \\/> enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi<br \\/> ut aliquip ex ea commodo consequat.\",\"image_content\":\"\",\"icon_content\":\"fa-cogs\",\"btn_content\":\"Read More\",\"button_url\":\"#\",\"button_target\":\"same\",\"button_icon_position\":\"left\",\"button_icon_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":\"100\",\"animation_slide_to\":\"0\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"content_color\":\"#ffffff\",\"content_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_letterspacing\":\"0px\",\"content_background\":\"\",\"image_content_width\":{\"xxl\":400,\"xl\":400,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_content_height\":{\"xxl\":385,\"xl\":385,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"rgba(68, 68, 68, 0)\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"content_border\":\"1px 1px 1px 1px\",\"content_border_color\":\"#ffffff\",\"content_border_radius\":\"0\",\"content_margin\":{\"xxl\":\"50px 0px 0px 0px\",\"xl\":\"50px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"content_padding\":{\"xxl\":\"17px 40px 15px 40px\",\"xl\":\"17px 40px 15px 40px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_hover_separator\":\"\",\"button_hover_color\":\"#000000\",\"button_background_color_hover\":\"#F5A623\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_hover_border_color\":\"#F5A623\",\"content_font_style\":{\"uppercase\":true,\"weight\":400},\"content_font_family\":\"Anton\"}],\"image_in_column\":0,\"image_column_width\":{\"xxl\":6,\"xl\":6,\"lg\":6,\"md\":6,\"sm\":6,\"xs\":6},\"image_column_reverse\":0,\"image_content_alignment\":\"left\",\"content_alignment\":\"left\",\"icon_display_block\":0,\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"gradient_overlay\",\"slider_bg_overlay\":\"#ffffff\",\"slider_bg_gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.25)\",\"color2\":\"rgba(255, 141, 0, 0.86)\",\"deg\":\"290\",\"pos2\":\"40\",\"pos\":\"69\",\"type\":\"linear\"},\"slider_video\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}}],\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0 0 0px 0\",\"xl\":\"0 0 0px 0\",\"lg\":\"0 0 20px 0\",\"md\":\"0 0 20px 0\",\"sm\":\"0 0 10px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"1\",\"blur\":\"12\",\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.55)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1586168484300,\"global_background_color\":\"#000000\",\"timer_color\":\"#F5A623\",\"slide_counter\":0,\"content_container_option\":\"custom\",\"pause_on_hover\":0,\"text_thumb_ctlr_wrap_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_thumb_cont_style\":\"thumb_number\",\"title_content_title\":\"\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\tCorabell&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"text_thumb_number_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"text_thumb_title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"text_thumb_subtitle_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Slideshow\",\"icon\":\"<svg viewbox=\\\"0 0 32 32\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M17.656 10.518a1.138 1.138 0 1 0 0 2.276 1.138 1.138 0 0 0 0-2.276ZM15 11.656a2.656 2.656 0 1 1 5.312 0 2.656 2.656 0 0 1-5.312 0ZM10 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm12 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm-6.636-9.909c.885.842 1.854 1.306 2.88 1.345 1.014.038 1.939-.343 2.738-.91 1.563-1.108 2.888-3.095 3.906-5.067l-1.776-.918c-.985 1.906-2.13 3.533-3.287 4.354-.561.398-1.06.56-1.505.543-.433-.017-.96-.207-1.578-.796-1.163-1.106-2.319-1.737-3.458-1.923-1.157-.188-2.186.101-3.042.63-1.648 1.018-2.698 2.941-3.185 4.318l1.886.666c.42-1.19 1.265-2.612 2.35-3.282.511-.316 1.058-.457 1.67-.358.628.102 1.432.477 2.4 1.398Z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M9 8h14v11H9V8ZM7 8a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2V8Zm-2.193 2.591A1 1 0 1 0 3.193 9.41L.236 13.444a1.246 1.246 0 0 0 0 1.46l2.703 3.687a1 1 0 1 0 1.613-1.182L2.18 14.174l2.626-3.583ZM16 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM27.409 9.193a1 1 0 0 1 1.398.216l2.957 4.035c.315.43.315 1.03 0 1.46l-2.703 3.687a1 1 0 1 1-1.613-1.182l2.371-3.235-2.626-3.583a1 1 0 0 1 .216-1.398Z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1578670002710,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"four images\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"2px 0px 121px 2px\",\"xl\":\"2px 0px 121px 2px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"-70px 0px 0px 0px\",\"xl\":\"-70px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#ffffff\",\"color2\":\"#dcdcdc\",\"deg\":\"180\",\"type\":\"linear\",\"pos2\":\"48\",\"pos\":\"0\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":0,\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.8)\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"turning-slope\",\"shape_color\":\"rgba(206, 206, 206, 0.61)\",\"shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"34\",\"xl\":\"34\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":1,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"47\",\"xl\":\"47\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1578670002710,\"id\":\"four_images\",\"row_border\":0,\"background_color\":\"\",\"background_video_mp4\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1578670002707,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1578670622038,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/mining-440743_640.jpg\",\"height\":480,\"width\":640},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.72)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.75)\",\"color2\":\"rgba(10, 10, 10, 0.7)\",\"deg\":\"183\",\"type\":\"linear\",\"pos\":\"33\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Mechanical Engineering\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do  eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"10PX 10PX 10PX 10PX\",\"xl\":\"10PX 10PX 10PX 10PX\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"100\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578670622038,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fas fa-rocket\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInLeft\",\"title_text_color\":\"\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"global_background_color\":\"#ffffff\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"Abel\",\"size\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"26\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":true,\"weight\":\"\",\"type\":\"google\"},\"sub_title_typography\":{\"font\":\"Abel\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"15\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1578670002708,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1578734839125,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/large-hydraulic-excavator-2576750_640.jpg\",\"height\":502,\"width\":640},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(0, 0, 0, 0.8)\",\"color2\":\"rgba(0, 0, 0, 0.7)\",\"deg\":\"7\",\"type\":\"linear\",\"pos2\":\"52\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(124, 255, 0, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Automotive Manufacturing\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do  eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"10PX 10PX 10PX 10PX\",\"xl\":\"10PX 10PX 10PX 10PX\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"300\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578734839125,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fa fa-comment\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInDown\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"title_text_color\":\"\",\"global_background_color\":\"#ffffff\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"Abel\",\"size\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"26\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":true,\"weight\":\"\",\"type\":\"google\"},\"sub_title_typography\":{\"font\":\"Abel\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"15\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1578670002709,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1578734839132,\"name\":\"image_overlay\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/excavator-2771230_640.jpg\",\"height\":426,\"width\":640},\"image_height\":300,\"background_image_animation\":\"slide-bottom\",\"image_in_lightbox\":0,\"lightbox_icon_bg\":\"#272727\",\"overlay_mode\":\"normal\",\"overlay_type\":\"color\",\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"overlay_gradient\":{\"color\":\"rgba(130, 255, 0, 0.8)\",\"color2\":\"rgba(11, 11, 11, 0.7)\",\"deg\":\"360\",\"type\":\"linear\",\"pos\":\"0\",\"pos2\":\"66\"},\"overlay_hover_type\":\"none\",\"overlay_hover_color\":\"rgba(155, 25, 234, 0.35)\",\"overlay_hover_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(255, 101, 0, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"title\":\"Petrol & Gas Engineering\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"26\",\"xl\":\"26\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_link\":\"#\",\"title_link_new_window\":0,\"title_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do  eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"subtitle_heading_selector\":\"div\",\"sub_title_fontsize\":{\"xxl\":\"15\",\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"sub_title_letterspace\":\"0\",\"sub_title_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_subtitle_position\":\"bottom-left\",\"show_content_on_hover\":0,\"content_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text\":\"\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"button_margin\":{\"xxl\":\"10px 0px 0px 0px\",\"xl\":\"10px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xxl\":\"1\",\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"10PX 10PX 10PX 10PX\",\"xl\":\"10PX 10PX 10PX 10PX\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"6\",\"blur\":\"5\",\"spread\":0,\"color\":\"#c5c5c5\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":1,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1578734839132,\"sub_title_text_color\":\"#ffffff\",\"title_font_style\":{\"underline\":true},\"sub_title_icon\":\"fa fa-book\",\"size\":\"sm\",\"shape\":\"square\",\"global_link_color\":\"#ffffff\",\"global_border_color\":\"#ffffff\",\"global_boder_style\":\"solid\",\"global_animation\":\"fadeInRight\",\"title_font_family\":\"Abel\",\"sub_title_font_family\":\"Abel\",\"title_text_color\":\"\",\"global_background_color\":\"#ffffff\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"Abel\",\"size\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"26\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":true,\"weight\":\"\",\"type\":\"google\"},\"sub_title_typography\":{\"font\":\"Abel\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"15\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Image Overlay\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 10.71l-9.718 5.9a5 5 0 01-5.8-.436l-3.622-3.024a3 3 0 00-3.583-.196l-6.781 4.503-1.106-1.666 6.78-4.503a5 5 0 015.971.327l3.623 3.024a3 3 0 003.48.262L30.25 9l1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 21c0 .552-.41 1-.917 1H5.917C5.41 22 5 21.552 5 21s.41-1 .917-1h20.166c.507 0 .917.448.917 1zM16 26a1 1 0 01-1 1H6a1 1 0 110-2h9a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M28 2H4a2 2 0 00-2 2v24a2 2 0 002 2h24a2 2 0 002-2V4a2 2 0 00-2-2zM4 0a4 4 0 00-4 4v24a4 4 0 004 4h24a4 4 0 004-4V4a4 4 0 00-4-4H4z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 6a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 8.077a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592380677128,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"80px 0px 102px 0px\",\"xl\":\"80px 0px 102px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/04\\/14\\/18647.jpg\",\"height\":3529,\"width\":5040},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"custom\",\"background_size_custom\":{\"xxl\":\"1289\",\"xl\":\"1289\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"100% 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592380677128,\"background_color\":\"#000000\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1592380677126,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592381195374,\"name\":\"animated_heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"heading_style\":\"highlighted\",\"heading_before_part\":\"EXCEVATOR\",\"highlighted_text\":\"CAT 365C\",\"highlighted_shape\":\"square\",\"shape_color\":\"#efa000\",\"shape_width\":\"4\",\"shape_radius\":0,\"animated_text\":\"awesome\\nnice\\ncool\",\"text_animation_name\":\"clip\",\"heading_after_part\":\"\",\"heading_selector\":\"h2\",\"style_options\":\"animated\",\"heading_fontsize\":{\"xxl\":\"38\",\"xl\":\"38\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"heading_lineheight\":\"\",\"heading_letterspace\":\"\",\"heading_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"heading_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"animated_text_fontsize\":{\"xxl\":\"53\",\"xl\":\"53\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"animated_text_letterspace\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 10px 0px\",\"xl\":\"0px 0px 10px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592381195374,\"animated_text_color\":\"#ffffff\",\"heading_color\":\"#ff9700\",\"highlighted_text_font_family\":\"Anton\",\"heading_font_family\":\"Anton\",\"global_animation\":\"bounceIn\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"animated_text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"53\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"53\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"highlighted_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"heading_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"38\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"38\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Animated Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M18.2 12c-2.1.3-4.1 2.1-5.5 4.4C10.8 11.3 7.1 7 2.5 7c-.4 0-.8 0-1.1.1-.8.1-1.4.8-1.4 1.6 0 1 .9 1.7 1.9 1.6.2-.1.4-.1.6-.1 4.3 0 8.2 7 8.2 13.1 0 .8.6 1.5 1.3 1.6 1.1.2 2-.6 2-1.6 0-3.1 2.3-7.3 4.3-8-.1-.6-.2-1.2-.2-1.8 0-.6 0-1 .1-1.5z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M26.3 19.3c3.2 0 5.7-2.6 5.7-5.7s-2.6-5.7-5.7-5.7-5.7 2.6-5.7 5.7 2.5 5.7 5.7 5.7z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592381349133,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"500\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592381349133,\"global_text_color\":\"#ffffff\",\"global_animation\":\"fadeIn\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592381856243,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Read More \",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"outline\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"hover\",\"background_color\":\"#ffffff\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"rgba(255, 255, 255, 0.07)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592381856243,\"icon\":\"fas fa-house-damage\",\"font_family\":\"Anton\",\"shape\":\"square\",\"url\":\"https:\\/\\/diablodesign.eu\\/\",\"global_animation\":\"fadeInLeftBig\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592380677127,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592380908830,\"name\":\"video\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=4Y31MD36xF4\",\"show_rel_video\":0,\"no_cookie\":0,\"mp4_enable\":0,\"mp4_video\":{\"src\":\"https:\\/\\/www.joomshaper.com\\/media\\/videos\\/2017\\/11\\/10\\/pb-intro-video.mp4\"},\"ogv_video\":{\"src\":\"\"},\"video_poster\":{\"src\":\"https:\\/\\/www.joomshaper.com\\/images\\/2017\\/11\\/10\\/real-time-frontend.jpg\"},\"show_control\":1,\"video_loop\":0,\"video_mute\":1,\"autoplay_video\":0,\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":\"0\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":\"9\",\"color\":\"#ffffff\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592380908830,\"global_background_color\":\"#ffffff\",\"global_animation\":\"bounceInRight\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Video\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><g opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" fill=\\\"currentColor\\\"><path d=\\\"M30.1 22.1H1.9c-.5 0-.9.4-.9.9s.4 1 .9 1H8v6.1c0 .5.5.9 1 .9s.9-.4.9-.9V24h5.2v6.1c0 .5.4.9.9.9s.9-.4.9-.9V24h5.2v6.1c0 .5.4.9.9.9s.9-.4.9-.9V24H30c.5 0 .9-.4.9-.9.1-.6-.3-1-.8-1zM1.9 9.9H30c.6 0 1-.4 1-.9s-.4-1-.9-1H24V1.9c0-.5-.5-.9-1-.9s-.9.4-.9.9V8h-5.2V1.9c0-.5-.4-.9-.9-.9s-.9.4-.9.9V8H9.9V1.9c0-.5-.4-.9-.9-.9s-1 .4-1 .9V8H1.9c-.5 0-.9.5-.9 1s.4.9.9.9z\\\"\\/><\\/g><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.1 27.6c0 1.2 1 2.2 2.2 2.2h23.2c1.2 0 2.2-1 2.2-2.2V4.4c0-1.2-1-2.2-2.2-2.2H4.4c-1.2 0-2.2 1-2.2 2.2v23.2h-.1zm2.3 4.2c-2.3 0-4.2-1.9-4.2-4.2V4.4C.2 2 2 .2 4.4.2h23.2c2.3 0 4.2 1.9 4.2 4.2v23.2c0 2.3-1.9 4.2-4.2 4.2H4.4z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.5 15c.6.5.6 1.5 0 1.9l-3.9 2.8c-.7.5-1.7 0-1.7-1V13c0-.9 1-1.5 1.7-1l3.9 3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592385112050,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"38px 0px 0px 0px\",\"xl\":\"38px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"video\",\"background_gradient\":{\"color\":\"#4b4b4b\",\"color2\":\"#ffffff\",\"deg\":\"174\",\"type\":\"linear\",\"pos2\":\"64\",\"pos\":\"0\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_mp4\":{\"src\":\"media\\/videos\\/2020\\/06\\/16\\/construction-site---10877.mp4\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"#ffffff\",\"color2\":\"rgba(255, 255, 255, 0.81)\",\"deg\":\"360\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":1,\"shape_name\":\"brushed\",\"shape_color\":\"#000000\",\"shape_width\":{\"xxl\":\"140\",\"xl\":\"140\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"66\",\"xl\":\"66\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"232\",\"xl\":\"232\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"57\",\"xl\":\"57\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":0,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592385112050,\"overlay\":\"rgba(255, 255, 255, 0.94)\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1592385112048,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592393330535,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/06\\/17\\/sk130lc-11_na_cob.png\",\"height\":700,\"width\":800},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"-110px 0px 30px 0px\",\"xl\":\"-110px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":53,\"name\":\"move\",\"property\":{\"x\":\"1\",\"y\":\"-8\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":23,\"name\":\"move\",\"property\":{\"x\":\"-392\",\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592393330535,\"image_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592385112049,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592394736441,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"KOBELCO EXCEVATOR\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"99\",\"xl\":\"99\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"-70px 0px 10PX 0px\",\"xl\":\"-70px 0px 10PX 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":\"6\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":0,\"color\":\"#fff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"900\",\"global_animationdelay\":\"600\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592394736441,\"title_font_family\":\"Anton\",\"global_animation\":\"bounceInUp\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"99\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"99\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592385112178,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.<\\/p>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"500\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592385112178,\"global_text_color\":\"#000000\",\"global_animation\":\"fadeIn\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592395370596,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Read More\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"background_color\":\"#000000\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#ffffff\",\"background_color_hover\":\"rgba(0, 0, 0, 0.43)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592395370596,\"size\":\"lg\",\"shape\":\"square\",\"font_family\":\"Anton\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592723338889,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"Pricing Table 03\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"14px 0px 0px 0px\",\"xl\":\"14px 0px 0px 0px\",\"lg\":\"100px 0px 100px 0px\",\"md\":\"100px 0px 100px 0px\",\"sm\":\"50px 0px 30px 0px\",\"xs\":\"50px 0px 30px 0px\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"custom\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"external_background_video\":\"0\",\"show_top_shape\":1,\"shape_name\":\"brushed\",\"shape_color\":\"#ffffff\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"53\",\"xl\":\"53\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#060606\",\"color\":\"#fff\",\"instFormId\":1592723338889,\"row_border\":0,\"background_type\":\"image\",\"overlay_type\":\"overlay_color\",\"background_size_custom\":{\"xxl\":\"2911\",\"xl\":\"2911\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1592723338925,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592724929605,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Equipment work\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"69\",\"xl\":\"69\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":{\"ho\":\"02\",\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592724929605,\"global_text_color\":\"#343434\",\"title_font_family\":\"Anton\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"69\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"69\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"17\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"17\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592723338927,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"text_lineheight\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"22\",\"xs\":\"22\"},\"dropcap\":0,\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 40px 0px\",\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_text_color\":\"#bcbcbc\",\"instFormId\":1592723338927,\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"14\",\"unit\":\"px\"},\"xxl\":{\"value\":\"18\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"29\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"22\",\"unit\":\"px\"},\"xs\":{\"value\":\"22\",\"unit\":\"px\"},\"xxl\":{\"value\":\"29\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1592723338928,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592723340519,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"86px 0px 98px 0px\",\"xl\":\"86px 0px 98px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_mp4\":{\"src\":\"media\\/videos\\/2020\\/06\\/16\\/construction-site---10877.mp4\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"#ffffff\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"360\",\"type\":\"linear\",\"pos2\":\"65\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":{\"ho\":\"0\",\"vo\":\"0\",\"blur\":\"0\",\"spread\":\"0\",\"color\":\"\",\"inset\":false},\"show_top_shape\":0,\"shape_name\":\"brushed\",\"shape_color\":\"#000000\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"30\",\"xl\":\"30\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#000000\",\"bottom_shape_width\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"75\",\"xl\":\"75\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592723340519,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"hidden_xl\":0,\"hidden_lg\":0},\"layout\":\"6,6\",\"columns\":[{\"id\":1592723340517,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592739441484,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/06\\/16\\/large-hydraulic-excavator-2576750_640.jpg\",\"height\":502,\"width\":640},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":\"16\",\"vo\":\"20\",\"blur\":\"0\",\"spread\":\"0\",\"color\":\"#000000\",\"inset\":false},\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592739441484,\"global_animation\":\"fadeInLeftBig\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592723340518,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592740452409,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"ACTIVITY PROFILE\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xxl\":\"66\",\"xl\":\"66\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 10px 0px\",\"xl\":\"0px 0px 10px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592740452409,\"title_font_family\":\"Anton\",\"global_animation\":\"bounceIn\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"66\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"66\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592745295709,\"name\":\"divider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_vertical\":0,\"divider_height_vertical\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"divider_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"divider_position\":\"\",\"container_div_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"solid\",\"border_width\":\"1\",\"border_radius\":\"\",\"border_color\":\"#cccccc\",\"margin_top\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"margin_bottom\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592745295709,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\"},\"title\":\"Divider\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16 1c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0V1.937c0-.517.42-.937.937-.937zm0 10.547c.518 0 .938.42.938.937v7.032a.937.937 0 11-1.875 0v-7.032c0-.517.42-.937.937-.937zm0 14.062c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0v-3.515c0-.518.42-.938.937-.938z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M21.625 23.3V8.7c0-1.011 1.198-1.518 1.898-.803l7.151 7.3a1.152 1.152 0 010 1.605l-7.151 7.3c-.7.716-1.898.21-1.898-.802z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M10.375 8.7v14.6c0 1.011-1.197 1.518-1.898.803l-7.151-7.3a1.152 1.152 0 010-1.605l7.151-7.3c.7-.716 1.898-.21 1.898.802z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":\"6qaAbsOiw_Frvfj-IrXxf\",\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"custom\",\"sp_tab_item\":[{\"title\":\"Heavy equipment\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-helicopter\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"Ibf79UW01GcQgunRzmc5n\",\"name\":\"row\"}]},{\"title\":\"Light equipment\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-tractor\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"Fih228Ru_G0rwhBWXc7UA\",\"name\":\"row\"}]},{\"title\":\"Specialist gear\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-truck-monster\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"GAsDbBpZfmDDapjBaCaMC\",\"name\":\"row\"}]},{\"title\":\"Special services\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fas fa-tools\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"RbqRky3WJBL0WyfJHjKUB\",\"name\":\"row\"}]},{\"title\":\"Our offer\",\"subtitle\":\"\",\"image_or_icon\":\"icon\",\"icon\":\"fab fa-whmcs\",\"image\":{\"src\":\"\"},\"content\":[{\"type\":\"nested_row\",\"id\":\"n9lnYS_wxBx1oKWcSKiuR\",\"name\":\"row\"}]}],\"custom_tab_style\":\"navigation\",\"nav_gutter\":{\"xxl\":\"4\",\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_style\":\"normal\",\"nav_width\":{\"xxl\":\"33\",\"xl\":\"33\",\"lg\":30,\"md\":30,\"sm\":30,\"xs\":30},\"nav_color\":\"#fff\",\"nav_bg_color\":\"#000\",\"nav_fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"nav_border\":\"1px 1px 1px 1px\",\"nav_border_color\":\"#e5e5e5\",\"nav_border_radius\":\"\",\"nav_margin\":{\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \",\"xxl\":\"0px 0px 5px 0px\"},\"nav_padding\":{\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \",\"xxl\":\"10px 10px 10px 10px\"},\"nav_text_align\":\"left\",\"hover_tab_bg\":\"\",\"hover_tab_color\":\"\",\"hover_tab_border_width\":\"\",\"hover_tab_border_color\":\"\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"active_tab_border_width\":\"\",\"active_tab_border_color\":\"\",\"image_or_icon_style\":\"icon_style\",\"nav_icon_postion\":\"left\",\"icon_fontsize\":{\"xxl\":\"17\",\"xl\":\"17\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xl\":\"0px 0px 0px 4px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \",\"xxl\":\"0px 0px 0px 4px\"},\"nav_image_postion\":\"left\",\"image_height\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_width\":{\"xxl\":30,\"xl\":30,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"image_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_color\":\"#000\",\"content_backround\":\"\",\"content_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_border\":\"0\",\"content_border_radius\":\"\",\"content_border_color\":\"\",\"show_boxshadow\":1,\"shadow_color\":\"#000\",\"shadow_horizontal\":\"\",\"shadow_vertical\":\"\",\"shadow_blur\":\"\",\"shadow_spread\":\"\",\"content_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \",\"xxl\":\"   \"},\"content_padding\":{\"xl\":\"10px 10px 10px 10px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \",\"xxl\":\"10px 10px 10px 10px\"},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"10px 0px 30px 0px\",\"xl\":\"10px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"300\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":\"6qaAbsOiw_Frvfj-IrXxf\",\"nav_font_family\":\"Anton\",\"icon_color\":\"#ff9800\",\"global_animation\":\"fadeInRightBig\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"nav_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"content_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"nav_color_tab\":\"normal\"},\"title\":\"Tabs\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M30 2.6H2a.4.4 0 00-.4.4v3c0 .22.18.4.4.4h28a.4.4 0 00.4-.4V3a.4.4 0 00-.4-.4zM2 1a2 2 0 00-2 2v3a2 2 0 002 2h28a2 2 0 002-2V3a2 2 0 00-2-2H2z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M7.6 8.6v20.8h17.8V8.6H7.6zM7 7a1 1 0 00-1 1v22a1 1 0 001 1h19a1 1 0 001-1V8a1 1 0 00-1-1H7z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M22 14a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1zM22 19a1 1 0 01-1 1h-9a1 1 0 110-2h9a1 1 0 011 1zM17 24a1 1 0 01-1 1h-4a1 1 0 110-2h4a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M11 2a1 1 0 011-1h9a1 1 0 011 1v6H11V2z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744753075,\"name\":\"divider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"image\",\"divider_vertical\":0,\"divider_height_vertical\":{\"xxl\":\"100\",\"xl\":\"100\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"divider_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_repeat\":\"no-repeat\",\"divider_height\":\"1\",\"divider_position\":\"\",\"container_div_width\":{\"xxl\":\"581\",\"xl\":\"581\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"solid\",\"border_width\":\"1\",\"border_radius\":\"\",\"border_color\":\"#cccccc\",\"margin_top\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"margin_bottom\":{\"xxl\":\"14\",\"xl\":\"14\",\"lg\":20,\"md\":20,\"sm\":10,\"xs\":10},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592744753075,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\"},\"title\":\"Divider\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16 1c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0V1.937c0-.517.42-.937.937-.937zm0 10.547c.518 0 .938.42.938.937v7.032a.937.937 0 11-1.875 0v-7.032c0-.517.42-.937.937-.937zm0 14.062c.518 0 .938.42.938.938v3.515a.937.937 0 11-1.875 0v-3.515c0-.518.42-.938.937-.938z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M21.625 23.3V8.7c0-1.011 1.198-1.518 1.898-.803l7.151 7.3a1.152 1.152 0 010 1.605l-7.151 7.3c-.7.716-1.898.21-1.898-.802z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M10.375 8.7v14.6c0 1.011-1.197 1.518-1.898.803l-7.151-7.3a1.152 1.152 0 010-1.605l7.151-7.3c.7-.716 1.898-.21 1.898.802z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592744680206,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"4px 0px 0px 0px\",\"xl\":\"4px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"50px 0px 50px 0px\",\"xs\":\"50px 0px 50px 0px\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"custom\",\"background_attachment\":\"scroll\",\"background_position\":\"100% 0\",\"background_video\":0,\"external_background_video\":\"0\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"brushed\",\"bottom_shape_color\":\"#ffffff\",\"bottom_shape_width\":{\"xxl\":\"247\",\"xl\":\"247\",\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"80\",\"xl\":\"80\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":1,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1592744680206,\"row_border\":0,\"background_type\":\"image\",\"background_color\":\"#000000\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"overlay_type\":\"overlay_color\",\"background_size_custom\":{\"xxl\":\"226\",\"xl\":\"226\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border_radius\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"gradient_overlay\":{\"color\":\"#000000\",\"color2\":\"#4527d0\"},\"background_position_custom_x\":{\"xxl\":\"1500\",\"xl\":\"1500\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_position_custom_y\":{\"xxl\":\"120\",\"xl\":\"120\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"hidden_xl\":0,\"hidden_lg\":0},\"layout\":\"12\",\"columns\":[{\"id\":1592744678934,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1592744678935,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1592744678938,\"title\":\"Row\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 28.857h26v-8.571H3v8.571zM1 29.93C1 30.52 1.448 31 2 31h28c.552 0 1-.48 1-1.071V19.214c0-.591-.448-1.071-1-1.071H2c-.552 0-1 .48-1 1.071V29.93zM3 11.714h26V3.143H3v8.571zm-2 1.072c0 .591.448 1.071 1 1.071h28c.552 0 1-.48 1-1.071V2.07C31 1.48 30.552 1 30 1H2c-.552 0-1 .48-1 1.071v10.715z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1586875655111,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"32px 0px 62px 0px\",\"xl\":\"32px 0px 62px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0 0px 0px 0px\",\"xl\":\"0 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#ff7d00\",\"color2\":\"#ffffff\",\"deg\":\"180\",\"type\":\"linear\",\"pos2\":\"20\",\"pos\":\"0\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.8)\",\"color2\":\"rgba(209, 209, 209, 0.27)\",\"deg\":\"0\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"slope\",\"shape_color\":\"rgba(255, 255, 255, 0.68)\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586875655111,\"background_color\":\"#e4e4e4\",\"row_border_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"hidden_xl\":0,\"hidden_lg\":0},\"layout\":\"12\",\"columns\":[{\"id\":1586875655110,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1738130925929,\"type\":\"content\",\"name\":\"articles\",\"visibility\":true,\"settings\":{\"resource\":\"article\",\"ordering\":\"latest\",\"include_subcat\":1,\"limit\":\"3\",\"layout\":\"default\",\"columns\":{\"xl\":\"3\",\"lg\":\"\",\"md\":\"1\",\"sm\":\"1\",\"xs\":\"\"},\"gap\":15,\"background_color\":\"#fff\",\"border\":1,\"border_width\":1,\"border_color\":\"#0000001a\",\"radius\":0,\"border_radius\":0,\"content_radius\":0,\"image_radius\":0,\"show_boxshadow\":0,\"shadow_color\":\"rgba(0, 0, 0, .5)\",\"overlay_color\":\"\",\"image_at\":\"COM_SPPAGEBUILDER_GLOBAL_LEFT\",\"hide_thumbnail\":0,\"thumb_size\":\"image_thumbnail\",\"article_heading_selector\":\"h3\",\"article_title_status\":\"normal\",\"article_title_text_color\":\"#ec430f\",\"article_title_text_color_hover\":\"#044CD0\",\"show_intro\":\"1\",\"intro_limit\":200,\"intro_color\":\"#252525\",\"show_custom_field\":1,\"show_author\":1,\"author_color\":\"#888\",\"show_tags\":1,\"tags_border_radius\":0,\"tags_status\":\"normal\",\"tags_color\":\"#ec430f\",\"tags_color_hover\":\"#fff\",\"tags_background_color\":\"rgba(236, 67, 15, 0.1)\",\"tags_background_color_hover\":\"#044CD0\",\"show_category\":1,\"category_status\":\"normal\",\"category_color\":\"#ec430f\",\"category_color_hover\":\"#044CD0\",\"show_date\":1,\"show_date_text\":\"\",\"date_color\":\"#888\",\"show_last_modified_date\":0,\"show_last_modified_date_text\":\"\",\"last_modified_date_color\":\"#888\",\"show_readmore\":1,\"readmore_text\":\"Read More\",\"readmore_status\":\"normal\",\"readmore_color\":\"#ec430f\",\"readmore_color_hover\":\"#044CD0\",\"link_articles\":0,\"all_articles_btn_text\":\"See all posts\",\"all_articles_btn_type\":\"custom\",\"all_articles_btn_link_padding_bottom\":\"\",\"all_articles_btn_appearance\":\"\",\"all_articles_btn_shape\":\"rounded\",\"all_articles_btn_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"8px 22px 10px 22px\",\"md\":\"8px 22px 10px 22px\",\"sm\":\"8px 22px 10px 22px\",\"xs\":\"8px 22px 10px 22px\"},\"all_articles_btn_icon_position\":\"left\",\"all_articles_btn_status\":\"normal\",\"all_articles_btn_color\":\"#FFFFFF\",\"all_articles_btn_background_color\":\"#3366FF\",\"all_articles_btn_background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"all_articles_btn_color_hover\":\"#FFFFFF\",\"all_articles_btn_background_color_hover\":\"#0037DD\",\"all_articles_btn_background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"all_articles_btn_link_status\":\"normal\",\"all_articles_btn_link_border_color\":\"\",\"all_articles_btn_link_hover_color\":\"\",\"all_articles_btn_link_border_hover_color\":\"\",\"heading_selector\":\"h3\",\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1738130925929,\"content_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"intro_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"intro_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"tags_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"tags_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"readmore_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"readmore_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M11.643 9.571h-.603L8.138 1.246A.363.363 0 007.804 1h-1.63a.363.363 0 00-.335.246L2.937 9.57h-.58c-.2 0-.357.179-.357.358v.714c0 .2.156.357.357.357h3.036a.367.367 0 00.357-.357v-.714a.384.384 0 00-.357-.358h-.536l.58-1.785h3.08l.604 1.785h-.514c-.2 0-.357.179-.357.358v.714c0 .2.156.357.357.357h3.036a.367.367 0 00.357-.357v-.714a.384.384 0 00-.357-.358zm-5.76-3.28l.938-2.769c.09-.357.157-.647.179-.78 0 .155.045.446.156.78l.938 2.768h-2.21z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M30 16a1 1 0 01-1 1H3a1 1 0 110-2h26a1 1 0 011 1zM30 23a1 1 0 01-1 1H3a1 1 0 110-2h26a1 1 0 011 1zM16 30a1 1 0 01-1 1H3a1 1 0 110-2h12a1 1 0 011 1zM30 9a1 1 0 01-1 1H16a1 1 0 110-2h13a1 1 0 011 1zM30 2a1 1 0 01-1 1H16a1 1 0 110-2h13a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Articles\",\"parent\":false}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1586877522719,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"22px 0px 50px 0px\",\"xl\":\"22px 0px 50px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#ffffff\",\"color2\":\"#dbdbdb\",\"deg\":\"360\",\"type\":\"linear\",\"pos\":\"18\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":1,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"xxl\":\"155\",\"xl\":\"155\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"background_position_custom_y\":{\"xxl\":\"456\",\"xl\":\"456\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"external_background_video\":0,\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"media\\/videos\\/2020\\/04\\/06\\/welcome---24829.mp4\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(255, 255, 255, 0.8)\",\"color2\":\"rgba(255, 255, 255, 0.7)\",\"deg\":\"15\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"darken\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":1,\"shape_name\":\"slope\",\"shape_color\":\"#ff8400\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":{\"xxl\":\"25\",\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":1,\"shape_invert\":1,\"shape_to_front\":0,\"show_bottom_shape\":1,\"bottom_shape_name\":\"hill-wave\",\"bottom_shape_color\":\"#ff8400\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586877522719,\"background_color\":\"#ffffff\",\"row_border_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay\":\"\",\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1586877522718,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1586878849857,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Contact our office\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":\"0\",\"blur\":0,\"spread\":0,\"color\":\"#ff0101\",\"inset\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586878849857,\"global_text_color\":\"#bcbcbc\",\"title_font_family\":\"Play\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Play\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592804498527,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images\\/2020\\/06\\/22\\/woman-851446_1280.jpg\",\"height\":959,\"width\":1280},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1592804498527,\"global_animation\":\"bounceIn\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1586877522728,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1586878146938,\"name\":\"ajax_contact\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"recipient_email\":\"email@yourdomain.com\",\"from_name\":\"\",\"from_email\":\"\",\"show_phone\":0,\"field_bg_color\":\"\",\"field_color\":\"\",\"field_placeholder_color\":\"\",\"input_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_font_size\":\"\",\"field_border_width\":\"\",\"field_border_color\":\"\",\"field_border_radius\":\"\",\"field_margin\":{\"xxl\":\"0px 0px 20px 0px\",\"xl\":\"0px 0px 20px 0px\",\"lg\":\"0px 0px 15px 0px\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 15px 0px\"},\"field_padding\":\"\",\"textarea_height\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_hover_bg_color\":\"\",\"field_hover_placeholder_color\":\"\",\"field_focus_border_color\":\"\",\"formcaptcha\":1,\"captcha_type\":\"default\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_input_col\":\"12\",\"captcha_answer\":\"7\",\"name_input_col\":\"12\",\"email_input_col\":\"12\",\"subject_input_col\":\"12\",\"phone_input_col\":\"12\",\"message_input_col\":\"12\",\"show_label\":0,\"show_checkbox\":1,\"checkbox_title\":\"I agree with the <a href=\\\"#\\\">Terms of Use<\\/a> and <a href=\\\"#\\\">Privacy Policy<\\/a> and I declare that I have read the information that is required in accordance with <a href=\\\"http:\\/\\/eur-lex.europa.eu\\/legal-content\\/EN\\/TXT\\/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.<\\/a>\",\"use_custom_button\":1,\"button_text\":\"Send Message\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"fontsize\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_appearance\":\"outline\",\"button_status\":\"normal\",\"button_background_color\":\"#b8b4b4\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#848484\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"button_icon_margin\":\"\",\"button_position\":\"sppb-text-right\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"70px 0px 30px 0px\",\"xl\":\"70px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586878146938,\"button_shape\":\"square\",\"button_icon_position\":\"left\",\"button_icon\":\"fab fa-telegram-plane\",\"global_text_color\":\"#dbdbdb\",\"global_link_color\":\"#ffc687\",\"global_animation\":\"zoomIn\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Contact Form\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M10 30V2h3a1 1 0 100-2H5a1 1 0 100 2h3v28H5a1 1 0 100 2h8a1 1 0 100-2h-3z\\\" fill=\\\"currentColor\\\"\\/><g opacity=\\\".5\\\" fill=\\\"currentColor\\\"><path d=\\\"M5 4a1 1 0 110 2H2v20h3a1 1 0 110 2H2a2 2 0 01-2-2V6a2 2 0 012-2h3zM30 4a2 2 0 012 2v20a2 2 0 01-2 2H13a1 1 0 110-2h17V6H13a1 1 0 110-2h17z\\\"\\/><\\/g><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1579327022890,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xxl\":\"0px 0px 2px 0px\",\"xl\":\"0px 0px 2px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1579327022890,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1579327022889,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1579328695019,\"name\":\"openstreetmap\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"height\":{\"xxl\":\"389\",\"xl\":\"389\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"map_style\":\"CartoDB.Positron\",\"multi_location_items\":[{\"title\":\"Location Item Title\",\"location_item\":\"50.09711, 20.05282\",\"location_popup_text\":\"Os na stoku Krakow Poland\",\"custom_icon\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"}}],\"zoom\":\"16\",\"mousescroll\":0,\"dragging\":1,\"zoomcontrol\":1,\"attribution\":1,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1579328695019,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\"},\"title\":\"Open Street Map\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M12.3 12.125c-.232-2.793.475-5.33 2.202-7.567.327-.43.691-.823 1.077-1.195.503-.485 1.042-.935 1.582-1.387l.087-.072c-.297-.172-.61-.285-.919-.397-.378-.137-.749-.271-1.074-.507h-.348c-.756.3-1.546.493-2.336.686-.432.105-.864.21-1.29.334-.98.28-1.97.53-2.96.78-.404.102-.809.205-1.213.31l-.024.005c-.175.044-.332.084-.532.017a649.995 649.995 0 00-4.106-1.341l-.089-.029-2.097-.68c-.026 0-.039-.026-.053-.052A.339.339 0 00.19 1H.074l.021.063.087.258.008.027.07.208.07.213.538 1.613c.422 1.262.847 2.525 1.28 3.783.128.36.14.684.012 1.054-.313.91-.617 1.82-.921 2.73-.304.91-.608 1.819-.921 2.729-.116.37-.116.695 0 1.066.231.73.457 1.46.684 2.193.363 1.174.726 2.349 1.112 3.52.127.405.116.764 0 1.17a776.683 776.683 0 00-2.005 6.918c-.011.035-.027.07-.044.105-.048.106-.098.214-.037.335.209.44 1.298.719 1.68.406a8.165 8.165 0 00.319-.278c.233-.213.455-.436.678-.66l.139-.14c1.17-1.176 2.344-2.349 3.517-3.522 1.173-1.174 2.347-2.347 3.517-3.523.417-.417.88-.73 1.483-.556.533.15.939-.012 1.321-.337.117-.095.23-.195.344-.295.203-.18.407-.36.63-.516.278-.197.278-.37.127-.66-.355-.693-.704-1.395-1.053-2.099-.3-.603-.6-1.207-.905-1.806-.174-.348-.29-.73.023-1.009.569-.512.515-1.132.459-1.787a18.783 18.783 0 01-.007-.078zm-1.963.549a5.334 5.334 0 00-.01-.138l-.012-.153-.008-.09v-.003c-.258-3.108.487-6.005 2.316-8.558-.268.067-.525.133-.788.21h-.005c-1.01.29-2.048.552-3.049.805-.398.1-.79.2-1.172.298l-.008.002-.007.002-.03.008c-.174.048-.857.234-1.643-.027-.896-.297-1.79-.59-2.686-.88.265.787.532 1.572.802 2.356.264.75.299 1.538.015 2.364-.31.9-.612 1.802-.916 2.713l-.002.004c-.29.87-.584 1.748-.886 2.627.232.734.454 1.452.674 2.162.358 1.157.71 2.296 1.092 3.455l.004.013.004.013c.261.832.222 1.595.015 2.32l-.003.009-.003.01c-.292.987-.581 1.976-.868 2.965l1.782-1.783.002-.002a2033.18 2033.18 0 003.513-3.519l.004-.003c.465-.466 1.498-1.366 2.968-1.167l-.51-1.025c-.305-.614-.605-1.218-.88-1.756l-.003-.007-.003-.006c-.116-.231-.339-.707-.378-1.292a2.555 2.555 0 01.679-1.927zM30.494 23.273v-.002l-.158-1.294c-.067-.548-.134-1.1-.205-1.662l-.002-.02-.064-.51-.06.026a.914.914 0 00-.172.09c-.536.384-1.083.723-1.643 1.012-2.067 1.069-4.3 1.468-6.735 1.085a.859.859 0 00-.823.324c-.394.487-.834.464-1.333.209-.564-.286-1.128-.561-1.692-.837l-.845-.415-.029-.014c-1.432-.704-1.439-.707-2.475.536l-.046.055c-.287.34-.572.678-.44 1.173.197.742-.14 1.252-.626 1.738A2414.87 2414.87 0 007.9 29.97l-.607.606-.008.007v.001l-.095.095-.29.29c-.037.036-.084.071-.133.108-.137.102-.28.21-.203.355.085.17.237.118.394.065.078-.027.158-.054.232-.054a.342.342 0 00.156-.028l.057-.023c.036-.015.073-.03.111-.041l1.006-.287 1.362-.386.198-.056c1.34-.38 2.68-.76 4.016-1.149a1.838 1.838 0 011.17.035c1.088.394 2.18.784 3.272 1.174.806.287 1.612.575 2.418.866.302.115.58.127.881.011l1.602-.618c1.274-.493 2.55-.986 3.833-1.468.313-.116.51-.301.649-.602.483-1.03.971-2.055 1.458-3.078.33-.694.66-1.386.987-2.08l.025-.049c.063-.12.123-.238.103-.39zM13.024 27.7l.513-.15.01-.002a3.836 3.836 0 012.385.072l.008.003.007.002c1.088.394 2.169.78 3.256 1.168.73.26 1.462.522 2.2.788l1.306-.504c1.173-.454 2.357-.911 3.543-1.359.439-.931.883-1.866 1.325-2.795l.878-1.848-.008-.066a12.588 12.588 0 01-6.726 1.042 2.802 2.802 0 01-1.508.642c-.773.08-1.417-.174-1.82-.38-.551-.28-1.091-.543-1.646-.814-.285-.14-.573-.28-.87-.427l-.027-.013-.027-.013-.015.018a3.38 3.38 0 01-.254 1.716c-.27.63-.688 1.094-.994 1.4l-.008.008-1.528 1.512z\\\" fill=\\\"currentColor\\\"\\/><circle opacity=\\\".5\\\" cx=\\\"24.5\\\" cy=\\\"10.5\\\" r=\\\"7.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1586959917835,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"xxl\":\"24px 0px 2px 0px\",\"xl\":\"24px 0px 2px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images\\/2020\\/04\\/08\\/church.png\",\"height\":100,\"width\":100},\"background_parallax\":0,\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_gradient\",\"gradient_overlay\":{\"color\":\"rgba(0, 0, 0, 0.03)\",\"color2\":\"rgba(140, 140, 140, 0.24)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1586959917835,\"background_color\":\"#b4b4b4\",\"id\":\"\",\"row_border\":0,\"container_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"container_max_width\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1586959917885,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1586961580791,\"name\":\"clients\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"create_carousel\":1,\"carousel_margin\":20,\"carousel_autoplay\":1,\"carousel_speed\":2000,\"carousel_interval\":3500,\"carousel_arrow\":0,\"carousel_bullet\":0,\"count\":\"sppb-col-sm-3\",\"alignment\":\"sppb-text-center\",\"sp_clients_item\":[{\"title\":\"Diablodesign\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/logo_bl.png\",\"height\":99,\"width\":288},\"url_same_window\":0,\"url\":\"https:\\/\\/diablodesign.eu\\/\"},{\"title\":\"Templatki\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/templatkicom.png\",\"height\":56,\"width\":300},\"url_same_window\":0,\"url\":\"https:\\/\\/templatki.com\"},{\"title\":\"Biurorachunkowe.be\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/biurorachunkowe.png\",\"height\":134,\"width\":421},\"url_same_window\":0,\"url\":\"https:\\/\\/biurorachunkowe.be\\/\"},{\"title\":\"LOT\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/polishairlines.png\",\"height\":600,\"width\":1000},\"url_same_window\":0},{\"title\":\"ORLEN\",\"image\":{\"src\":\"images\\/2020\\/04\\/15\\/orlenlogo.png\",\"height\":148,\"width\":341},\"url_same_window\":0}],\"add_css_filder\":[\"grayscale\",\"opacity\"],\"grayscale_value\":\"100\",\"opacity_value\":\"77\",\"remove_filter\":1,\"scale_on_hover\":1,\"scale_value\":\"1.3\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1586961580791,\"carousel_item_number\":{\"xxl\":\"8\",\"xl\":\"8\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_link_color\":\"#4e4e4e\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Clients\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M26.7 16.7h-2.3c.2.6.4 1.3.4 2.1v8.8c0 .3-.1.6-.1.9h3.8c1.4 0 2.6-1.2 2.6-2.6v-4.8c-.1-2.4-2-4.4-4.4-4.4zM7.3 18.8c0-.7.1-1.4.4-2.1H5.3C2.9 16.7 1 18.6 1 21v4.8c0 1.4 1.2 2.6 2.6 2.6h3.8c-.1-.3-.1-.6-.1-.9v-8.7z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M23 28.4H9v-9.6c0-2.4 1.9-4.3 4.3-4.3h5.3c2.4 0 4.3 1.9 4.3 4.3v9.6h.1zm-12-2h10v-7.6c0-1.3-1-2.3-2.3-2.3h-5.3c-1.3 0-2.3 1-2.3 2.3v7.6H11zM16 13.4c-.9 0-1.8-.2-2.5-.7-1.6-.9-2.7-2.7-2.7-4.5C10.8 5.3 13.1 3 16 3c2.9 0 5.2 2.3 5.2 5.2 0 1.9-1 3.6-2.7 4.5-.7.5-1.6.7-2.5.7zM16 5c-1.8 0-3.2 1.4-3.2 3.2 0 1.2.6 2.2 1.6 2.8 1 .5 2.2.5 3.1 0 1-.6 1.6-1.6 1.6-2.8C19.2 6.4 17.8 5 16 5z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M6.9 7.9C4.7 7.9 3 9.6 3 11.7c0 2.1 1.7 3.9 3.9 3.9.5 0 1.1-.1 1.5-.3.8-.4 1.5-1 1.9-1.7.3-.5.5-1.2.5-1.8-.1-2.2-1.8-3.9-3.9-3.9zM25.1 7.9c-2.1 0-3.9 1.7-3.9 3.9 0 .7.2 1.3.5 1.8.4.8 1.1 1.4 1.9 1.7.5.2 1 .3 1.5.3 2.1 0 3.9-1.7 3.9-3.9 0-2.1-1.7-3.8-3.9-3.8z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1592723338928,\"settings\":{\"padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"30px 0px 0px 0px\",\"xl\":\"30px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"background_type\":\"none\"},\"layout\":\"4,4,4\",\"visibility\":true,\"columns\":[{\"id\":1592723338929,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"0px 0px 0px 0px\",\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1592723338930,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\" Gravel truck 30 tons\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"25\",\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$1200\",\"price_color\":\"\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"\",\"pricing_content_font_size\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":\"55\",\"xl\":\"55\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Buy Now\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_background_color\":\"#ffffff\",\"button_color\":\"#fff\",\"button_background_color_hover\":\"#ff5e00\",\"button_color_hover\":\"#fff\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"45px 45px 50px 45px\",\"xl\":\"45px 45px 50px 45px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_border_color\":\"#F2F2F2\",\"global_boder_style\":\"solid\",\"global_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"62\",\"xl\":\"62\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_overlay\":1,\"title_font_style\":{\"weight\":600},\"global_background_image\":{\"src\":\"images\\/2020\\/06\\/21\\/loader-1846346_640.jpg\",\"height\":428,\"width\":640},\"global_background_size\":\"cover\",\"global_background_repeat\":\"no-repeat\",\"instFormId\":1592723338930,\"button_status\":\"hover\",\"global_background_type\":\"image\",\"title_font_family\":\"Arial\",\"global_overlay_type\":\"overlay_color\",\"global_background_overlay\":\"rgba(0, 0, 0, 0.37)\",\"button_url\":\"https:\\/\\/diablodesign.eu\",\"button_target\":\"_blank\",\"global_pattern_overlay\":{\"src\":\"images\\/2020\\/06\\/21\\/86.jpg\",\"height\":619,\"width\":1980},\"pricing_hover_scale\":\"1\",\"pricing_hover_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"8\",\"spread\":0,\"color\":\"#ffb500\",\"inset\":false},\"hidden_xl\":0,\"hidden_lg\":0,\"title_typography\":{\"font\":\"Arial\",\"size\":{\"xl\":{\"value\":\"25\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"25\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":600,\"type\":\"google\"},\"pricing_content_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"price_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"36\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"36\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592723338931,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1592723338932,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Big rock truck 30 tons\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"24\",\"xl\":\"24\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$1169\",\"price_color\":\"\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"\",\"pricing_content_font_size\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":\"55\",\"xl\":\"55\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Buy Now\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_background_color\":\"#ffffff\",\"button_color\":\"#fff\",\"button_background_color_hover\":\"#ff5e00\",\"button_color_hover\":\"#fff\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"45px 45px 50px 45px\",\"xl\":\"45px 45px 50px 45px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_border_color\":\"#F2F2F2\",\"global_boder_style\":\"solid\",\"global_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"62\",\"xl\":\"62\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_overlay\":1,\"title_font_style\":{\"weight\":600},\"global_background_image\":{\"src\":\"images\\/2020\\/06\\/21\\/digger-1453430_640.jpg\",\"height\":376,\"width\":640},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"instFormId\":1592723338932,\"global_background_type\":\"image\",\"button_status\":\"hover\",\"global_overlay_type\":\"overlay_color\",\"title_font_family\":\"Arial\",\"global_background_overlay\":\"rgba(0, 0, 0, 0.37)\",\"pricing_hover_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"8\",\"spread\":0,\"color\":\"#ffb500\",\"inset\":false},\"pricing_hover_scale\":\"1\",\"hidden_xl\":0,\"hidden_lg\":0,\"title_typography\":{\"font\":\"Arial\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":600,\"type\":\"google\"},\"pricing_content_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"price_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"36\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"36\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592723338933,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592723338934,\"name\":\"pricing\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Demolition of buildings 1 hour\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"xxl\":\"18\",\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"xxl\":\"21\",\"xl\":\"21\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_margin_top\":{\"xxl\":0,\"xl\":0,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":20,\"xl\":20,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price\":\"$2000\",\"price_color\":\"\",\"price_font_size\":{\"xxl\":36,\"xl\":36,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"price_symbol\":\"\",\"price_symbol_alignment\":\"\",\"price_symbol_color\":\"\",\"price_symbol_font_size\":\"\",\"duration\":\"\",\"duration_color\":\"\",\"duration_font_size\":\"\",\"price_position\":\"after\",\"price_margin_bottom\":{\"xxl\":\"40\",\"xl\":\"40\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content\":\"\",\"pricing_content_font_size\":{\"xxl\":16,\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_gap\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"pricing_content_margin_bottom\":{\"xxl\":\"55\",\"xl\":\"55\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_text\":\"Buy Now\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"outline\",\"button_background_color\":\"#ffffff\",\"button_color\":\"#fff\",\"button_background_color_hover\":\"#ff5e00\",\"button_color_hover\":\"#fff\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"button_padding\":{\"xxl\":\"12px 35px 12px 35px\",\"xl\":\"12px 35px 12px 35px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px 0px 30px 0px\",\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"45px 45px 50px 45px\",\"xl\":\"45px 45px 50px 45px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_border_color\":\"#F2F2F2\",\"global_boder_style\":\"solid\",\"global_border_width\":{\"xxl\":\"2\",\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_border_radius\":{\"xxl\":\"10\",\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"62\",\"xl\":\"62\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_overlay\":1,\"title_font_style\":{\"weight\":600},\"global_background_image\":{\"src\":\"images\\/2020\\/06\\/21\\/crash-1651305_640.jpg\",\"height\":480,\"width\":640},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"instFormId\":1592723338934,\"button_status\":\"hover\",\"global_background_type\":\"image\",\"global_overlay_type\":\"overlay_color\",\"title_font_family\":\"Arial\",\"global_background_overlay\":\"rgba(0, 0, 0, 0.37)\",\"pricing_hover_scale\":\"1\",\"pricing_hover_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":\"8\",\"spread\":0,\"color\":\"#ffb500\",\"inset\":false},\"hidden_xl\":0,\"hidden_lg\":0,\"title_typography\":{\"font\":\"Arial\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"18\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"21\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"21\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":600,\"type\":\"google\"},\"pricing_content_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"price_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"36\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"36\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Pricing Table\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"11\\\" y=\\\"24\\\" width=\\\"10\\\" height=\\\"3\\\" rx=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"33.333333333333%\",\"xl\":\"33.333333333333%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592723338889,\"columnId\":1592723338925}},{\"id\":\"Ibf79UW01GcQgunRzmc5n\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"dM7ehG80U26uLFWj93plz\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592723337,\"name\":\"text_block\",\"settings\":{\"text\":\"<div style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.<\\/div>\",\"dropcap\":0,\"text_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_user_border\":0,\"global_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"instFormId\":1592723337,\"article_title_status\":\"normal\",\"tags_status\":\"normal\",\"category_status\":\"normal\",\"readmore_status\":\"normal\"},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592723340519,\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"Fih228Ru_G0rwhBWXc7UA\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"RFhUX0t2mcsDPc5J4w0gA\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592739045310,\"name\":\"text_block\",\"settings\":{\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt.\\n<div style=\\\"text-align: justify;\\\">\\u00a0<\\/div>\",\"dropcap\":0,\"text_fontsize\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"Ibf79UW01GcQgunRzmc5n\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"GAsDbBpZfmDDapjBaCaMC\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"MS8oCnqsd2_ojVUXyY-w4\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592739045815,\"name\":\"text_block\",\"settings\":{\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt.\\n<div style=\\\"text-align: justify;\\\">\\u00a0<\\/div>\",\"dropcap\":0,\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"Fih228Ru_G0rwhBWXc7UA\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"RbqRky3WJBL0WyfJHjKUB\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"UXdRcQEgDqYiBtkGbQ1vT\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592739046337,\"name\":\"text_block\",\"settings\":{\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt.\",\"dropcap\":0,\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"GAsDbBpZfmDDapjBaCaMC\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":\"n9lnYS_wxBx1oKWcSKiuR\",\"visibility\":true,\"collapse\":false,\"settings\":{\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"5px 0px 5px 0px\",\"margin\":\"0px 0px 0px 0px\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xxl\":100,\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"admin_label\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":\"jn9j5tx2YMtBrSSZlBCZO\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xxl\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592739047166,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"dropcap\":0,\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"visibility\":true}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"RbqRky3WJBL0WyfJHjKUB\",\"columnId\":1592723340518},\"parent_addon\":\"ahqVrzG7qq3YmgGuXnVGv\"},{\"id\":1592744678935,\"settings\":{\"padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true},\"background_type\":\"none\"},\"layout\":\"12\",\"visibility\":true,\"columns\":[{\"id\":1592744678936,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592744678937,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Our machines in use\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"xxl\":\"50\",\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"30\",\"xs\":\"30\"},\"title_lineheight\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"<div class=\\\"tlid-input input\\\">\\u00a0<\\/div>\\n<div class=\\\"tlid-results-container results-container\\\">\\n<div class=\\\"tlid-result result-dict-wrapper\\\">\\n<div class=\\\"result tlid-copy-target\\\">\\n<div class=\\\"text-wrap tlid-copy-target\\\">\\n<div class=\\\"result-shield-container tlid-copy-target\\\" tabindex=\\\"0\\\"><span class=\\\"tlid-translation translation\\\" lang=\\\"en\\\"><span class=\\\"\\\" title=\\\"\\\">Our machines rented to an external company<\\/span><\\/span><\\/div>\\n<\\/div>\\n<\\/div>\\n<\\/div>\\n<\\/div>\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"xxl\":\"29\",\"xl\":\"29\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"xxl\":\"14\",\"xl\":\"14\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dropcap\":0,\"class\":\"\",\"title_font_style\":{\"weight\":400},\"title_margin_top\":{\"xxl\":\"20\",\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"xxl\":\"0\",\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"25\",\"xs\":\"25\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"0px auto 45px auto\",\"xl\":\"0px auto 45px auto\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":1,\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"xxl\":\"58\",\"xl\":\"58\",\"lg\":\"90\",\"md\":\"90\",\"sm\":\"100\",\"xs\":\"100\"},\"instFormId\":1592744678937,\"text_font_family\":\"Anton\",\"title_text_color\":\"#ff7200\",\"font_family\":\"Anton\",\"global_text_color\":\"#ffffff\",\"global_animation\":\"fadeInUp\",\"hidden_xl\":0,\"hidden_lg\":0,\"text_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"29\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"29\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"14\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"50\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"30\",\"unit\":\"px\"},\"xs\":{\"value\":\"30\",\"unit\":\"px\"},\"xxl\":{\"value\":\"50\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":400,\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"100%\",\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592744680206,\"columnId\":1592744678934}},{\"id\":1592744678938,\"settings\":{\"padding\":{\"xxl\":\"86px 0px 84px 0px\",\"xl\":\"86px 0px 84px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xxl\":\"0px 0px 0px 0px\",\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"fit_columns\":{\"xxl\":true,\"xl\":true,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false},\"background_type\":\"none\"},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1592744678939,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592744678940,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"66\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\"Excavators\",\"show_percentage\":1,\"class\":\"\",\"instFormId\":1592744678940,\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"percentage_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744678941,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"38\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\" Bulldozers\",\"show_percentage\":1,\"class\":\"\",\"instFormId\":1592744678941,\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"percentage_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744678942,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"97\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\"Cranes\",\"show_percentage\":1,\"class\":\"\",\"instFormId\":1592744678942,\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"percentage_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"},{\"id\":1592744678943,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"progress\":\"73\",\"bar_height\":\"8\",\"type\":\"custom\",\"bar_background\":\"#ffffff\",\"progress_bar_background\":\"#ff7300\",\"text\":\"Trucks\",\"show_percentage\":1,\"class\":\"\",\"stripped\":\"sppb-progress-bar-striped\",\"text_color\":\"#ffffff\",\"instFormId\":1592744678943,\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"percentage_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Progress Bar\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"3\\\" width=\\\"7\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"24.877\\\" width=\\\"14\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z\\\" fill=\\\"currentColor\\\"\\/><rect x=\\\"2\\\" y=\\\"14.339\\\" width=\\\"20\\\" height=\\\"4.123\\\" rx=\\\"2.062\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1592744678944,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1592744678945,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"<p class=\\\"p1\\\" style=\\\"text-align: justify;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum. Pellentesque ultrices ultrices sapien, nec tincidunt nunc posuere ut. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam scelerisque tristique dolor vitae tincidunt. Aenean quis massa uada mi elementum elementum. Nec sapien convallis vulputate rhoncus vel dui.<\\/p>\",\"alignment\":\"\",\"text_fontsize\":{\"xxl\":\"16\",\"xl\":\"16\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_lineheight\":{\"xxl\":\"25\",\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"dropcap\":0,\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xxl\":\"\",\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":1,\"global_text_color\":\"rgba(255, 255, 255, 0.7)\",\"instFormId\":1592744678945,\"text_font_family\":\"Anton\",\"global_animation\":\"fadeInRight\",\"text_typography\":{\"font\":\"Anton\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"25\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"},\"xxl\":{\"value\":\"25\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\"}],\"width\":{\"xxl\":\"50%\",\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":1592744680206,\"columnId\":1592744678934}}]', 'com_sppagebuilder', 'page', '0', '0', '1', '0', '1', '1', '2018-02-22 07:16:05', '654', '2025-01-29 06:18:35', '654', '0', NULL, '{\"meta_description\":\"\",\"meta_keywords\":\"\",\"robots\":\"\",\"seo_spacer\":\"\",\"author\":\"\",\"og_type\":\"website\"}', '', '', '', '*', '16739', '', '5.4.6');/**ABDB**/
